#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#include <qdialog.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <kcolorbtn.h>
#include <qcheckbox.h>
#include "kpuissance4.h"

class OptionsDialog : public QDialog
{
	Q_OBJECT;

public:
	OptionsDialog(BoardOptionsStruct *o, QWidget *parent = 0, const char *name = 0);

	void loadOptions(BoardOptionsStruct *o);
	void readOptions(BoardOptionsStruct *o);

protected:
	QComboBox	*Player1;
	QComboBox	*Player2;
	QComboBox	*Level;
	QLineEdit	*NumCols;
	QLineEdit	*NumRows;
	QLineEdit	*NumPuis;
	KColorButton	*BackgroundColor;
	QCheckBox	*UsePixmap;
	QComboBox	*Pixmap;
	QLabel		*PixmapPreview;
	QStrList	PixmapList;

protected slots:
	void pixmapChanged(int item);
};

#endif