#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <kfm.h>
#include "kscore.h"
#include "roguec.h"
#include "kgame.h"

#define T(x) x

KGame *gam;

void kfmRefresh(const QString &fn)
{
  QString dir=fn.copy(), url="";
  unsigned int i;
  char c;
  dir.truncate(dir.findRev('/'));
  dir="file:"+dir+'/';
  for (i=0; i<dir.length(); i++)
  {
    c=dir[i];
    if (c==' ') url+="%20";
      else if (c=='+') url+="%2B";
        else url+=c;
  }
  KFM kfm;
  kfm.refreshDirectory(url);
}

static char nicknamebuf[30];

KGame::KGame(QObject *p, const char *name)
:QObject(p, name)
{
  cfg->setGroup("Settings");
  QString nick=cfg->readEntry("Nick");
  if (!(nick.isNull() || nick.isEmpty()))
  {
    strncpy(nicknamebuf, nick, 30);
    nick_name=nicknamebuf;
  }
  warn_on_search=cfg->readNumEntry("WarnOnSearch", 0);
  warn_on_rest=cfg->readNumEntry("WarnOnRest", 0);
}

void KGame::save()
{
  KConfig *cfg=kapp->getConfig();
  bool quit=0;
  cfg->setGroup("Settings");
  QString dir=cfg->readEntry("SaveDir");
  QString file=KFileDialog::getSaveFileName(dir, "*.krogue\n*", kapp->mainWidget());
  if (QFile::exists(file))
    if (KMsgBox::yesNo(kapp->mainWidget(), i18n("Rogue"),
        i18n("File already exists.\nDo you want to overwrite it?"),
        KMsgBox::EXCLAMATION)!=1)
      return;
  cfg->setGroup("Settings");
  if (file.isNull() || file.isEmpty()) return;
  dir=file;
  dir.truncate(dir.findRev('/'));
  if (save((const char *)file)==0) quit=1;
  kfmRefresh(file);
  cfg->writeEntry("SaveDir", dir);
  if (quit) kapp->quit();
}

int KGame::save(const char *fn)
{
  return save_into_file(fn);
}

void KGame::quit()
{
  kapp->quit();
}

int KGame::level()
{
  return cur_level;
}

int KGame::maxLevel()
{
  return max_level;
}

long KGame::rogueGold()
{
  return rogue.gold;
}

int KGame::rogueHpCur()
{
  return rogue.hp_current;
}

int KGame::rogueHpMax()
{
  return rogue.hp_max;
}

void KGame::checkStr()
{
  if (rogue.str_max > MAX_STRENGTH) 
  {
    rogue.str_current -= (rogue.str_max - MAX_STRENGTH);
    rogue.str_max = MAX_STRENGTH;
  }
}

int KGame::rogueStrCur()
{
  checkStr();
  return rogue.str_current+add_strength;
}

int KGame::rogueStrMax()
{
  checkStr();
  return rogue.str_max;
}

int KGame::rogueArmorClass()
{
  if (rogue.armor && (rogue.armor->d_enchant > MAX_ARMOR))
    rogue.armor->d_enchant = MAX_ARMOR;
  return get_armor_class(rogue.armor);
}

int KGame::rogueExp()
{
  return rogue.exp;
}

long KGame::rogueExpPoints()
{
  return rogue.exp_points;
}

const char *KGame::rogueNick()
{
  return (nick_name[0]?nick_name:NULL);
}

void KGame::setRogueNick(const char *nick)
{
  if (!nick || !nick[0]) nick_name="";
    else
    {
      strncpy(nicknamebuf, nick, 30);
      nick_name=nicknamebuf;
    }
  cfg->setGroup("Settings");
  cfg->writeEntry("Nick", nick_name);
  emit newNick();
  KScoreList list(false);
  list.setNick(login_name, nick_name);
}

const char *KGame::rogueName()
{
  return (nick_name[0]?nick_name:login_name);
}

bool KGame::warnOnSearch()
{
  return warn_on_search;
}

void KGame::setWarnOnSearch(bool b)
{
  warn_on_search=b;
  cfg->setGroup("Settings");
  cfg->writeEntry("WarnOnSearch", warn_on_search);
}

bool KGame::warnOnRest()
{
  return warn_on_rest;
}

void KGame::setWarnOnRest(bool b)
{
  warn_on_rest=b;
  cfg->setGroup("Settings");
  cfg->writeEntry("WarnOnRest", warn_on_rest);
}

const char *KGame::hungerStr()
{
  return (hunger_str[0]?hunger_str:NULL);
}
