#include <QwSpriteField.h>
#define _BaseCard_

class BaseCard : public QwMobileSprite {
public:
  BaseCard(QwSpritePixmapSequence& s, int ct);
  
  virtual bool setCardType(int ct)=0; 
  int cardType();
  virtual int cardSuit()=0;
  virtual int cardNum()=0;

  virtual void setFace(bool face)=0;  /* 1 == faceup, 2==facedown */
  virtual bool faceUp()=0;
  
  virtual void cleanCard()=0;
  
  virtual BaseCard* nextCard()=0;
  virtual BaseCard* prevCard()=0;
  virtual bool setNextCard(BaseCard* next)=0;
  virtual bool setPrevCard(BaseCard* prev)=0;

  virtual bool isTopCard()=0;
  virtual bool isCardAbove(BaseCard *card)=0;
  virtual bool isCardBelow(BaseCard *card)=0;
  virtual BaseCard* topCard()=0;

  virtual bool pickupCards()=0;
  virtual void putdownCards()=0;
  void moveTo(int, int);
  virtual void moveCardsTo(int nx, int ny)=0;
  virtual bool dragCardsTo(int nx, int ny, int nz, int dx=0, int dy=0, bool force=0)=0;
  virtual void putbackCards()=0;

  virtual bool dropCards(BaseCard *onCard, int dx, int dy)=0;

protected:
  void _setCardType(int ct);
private:
  int ctype;
};





