#include "CardTable.moc"
#include "CardTable.h"
#include <qcolor.h>

CardTable::CardTable(int width, int height, QWidget* parent=0, const char* name=0, WFlags f=0) :
  QWidget(parent,name,f),
  field(width, height, 50),
  view(&field, this)
{
  drag_card = NULL;
  msAction = msNone;
  view.installEventFilter(this);
}

bool CardTable::setBackground(const char* back) 
{
  return field.setBackground(back);
}

bool CardTable::eventFilter(QObject*, QEvent *e)
{
  if (e->type() == Event_MouseButtonDblClick) 
    {
      msAction = msDoubleClick;
    }
  else if (e->type() == Event_MouseButtonPress) 
    {
      mouseEv = (QMouseEvent*)e;
      bool gotone=0;
      for (Pix p = field.topAt(mouseEv->x(),mouseEv->y()); p; field.next(p))
	{
	  if (field.exact(p)) {
             drag_card = (BaseCard*)field.at(p);
	     gotone=1;
	  }
	}
      msAction = msClick;
      if (gotone) {
	msActionX = drag_card->x() - mouseEv->x();
	msActionY = drag_card->y() - mouseEv->y();
      }
      else { drag_card = NULL; /* Be sure we don't have a left over drag_card! */ }
      return TRUE;
    }
  else if (e->type() == Event_MouseMove && msAction == msClick)           /* PICKUP EVENT */
    {
      if (drag_card && startDragEvent(drag_card)) { msAction = msDrag; }
      else { 
	msAction = msNone;
	drag_card = NULL;
      }
      return TRUE;
    }
  else if (e->type() == Event_MouseMove && msAction == msDrag)            /* DRAG EVENT */
    {
      mouseEv = (QMouseEvent*)e;
      if (!dragEvent(drag_card, mouseEv->x() + msActionX, mouseEv->y() + msActionY)) 
	{ msAction = msNone; }
      return TRUE;
    }
  else if (e->type() == Event_MouseButtonRelease) {

    if (msAction == msDrag) {                                             /* DROP EVENT */
      bool dropped = 0;
      preDropEvent(drag_card);
      for (Pix p = drag_card->neighbourhood(drag_card->frame()); p; field.next(p))
	{
	  BaseCard *temp_card = (BaseCard*)drag_card->at(p);
	  if (drag_card != temp_card && !drag_card->isCardAbove(temp_card) &&
	      dropEvent(drag_card, temp_card)) 
	    {
	      dropped = 1;
	      break;
	    }
	}
      if (!dropped) dropFailedEvent(drag_card);
    }
    else if (msAction == msClick) {                                       /* CLICK EVENT */ 
      clickEvent(drag_card, mouseEv->x(), mouseEv->y(), mouseEv->button());
    }
    else if (msAction == msDoubleClick) {                                 /* DOUBLE CLICK EVENT */
      doubleClickEvent(drag_card, mouseEv->x(), mouseEv->y(), mouseEv->button());
      drag_card = NULL;
    }
    msAction = msNone;
    return TRUE;
  }
  return FALSE;  
}

void CardTable::timerEvent(QTimerEvent *)
{
  field.update();
};

void CardTable::resizeEvent(QResizeEvent* event) 
{
  QWidget::resizeEvent(event);
  view.resize(width(),height());
  field.resize(width(),height());
};











