#include "SolQwImageSpriteField.h"

SolQwImageSpriteField::SolQwImageSpriteField(int w, int h, int chunksize, int maxclusters) :
  QwSpriteField(w, h, maxclusters, chunksize)
{}

SolQwImageSpriteField::~SolQwImageSpriteField() {}
    
bool SolQwImageSpriteField::setBackground(const char* filename)
{
  if (!image.load(filename)) return 0;
  resize(width(),height());
  return 1;
}

void SolQwImageSpriteField::drawBackground(QPainter& painter, const QRect& area)
{
  if (image.isNull()) QwSpriteField::drawBackground(painter,area);
  else {
    for (int x=area.x()/image.width();
	 x<(area.x()+area.width()+image.width()-1)/image.width(); x++)
      {
	for (int y=area.y()/image.height();
	     y<(area.y()+area.height()+image.height()-1)/image.height(); y++)
	  {
	    painter.drawPixmap(x*image.width(), y*image.height(),image);
	  }
      }
  }
}                                       

