#ifndef _SolTable_
#define _SolTable_

#include <qstring.h>
#include <qdialog.h>
#include <qevent.h> 
#include <kconfig.h>

#include "CardTable.h"
#include "Cards.h"

#define REFRESH_DELAY 20

class SolTable;
class SolTableOptions;


class SolUndo {
public:
  enum UndoTypes{ NoUndo, DeckToDraw, Flip, CardToCard };

  SolUndo() { lowCard=NULL; hiCard=NULL; lastAction=NoUndo; }
  void reset() { lowCard=NULL; hiCard=NULL; lastAction=NoUndo; }
  BaseCard *lowCard, *hiCard;
  UndoTypes lastAction;
  int old_score;
};



class SolTable : public CardTable {
  Q_OBJECT
public:
  friend class SolTableOptions;

  enum CardType { DeckCard,  DrawCard,  AcePileCard,  PlayCard,
		  DeckOutline,  DrawOutline,  AcePileOutline,  PlayOutline};
  enum CardSuit { NoSuit, Hearts, Diamonds, Clubs, Spades };
  enum CardNum { NoNum=0, Ace=1, Two=2,Three=3,Four=4,Five=5,Six=6,Seven=7,Eight=8,Nine=9,
		 Ten=10,Jack=11,Queen=12,King=13};
  enum GameStyle { Normal, Vegas };
  enum DrawNum { DrawOne=1, DrawThree=3 };
  
  SolTable(QWidget *par = NULL);
  ~SolTable();

protected:
  void initBoard();
  void deal();

  bool startDragEvent(BaseCard *card);
  bool dragEvent(BaseCard *card, int nx, int ny);
  void preDropEvent(BaseCard *card);
  bool dropEvent(BaseCard *card, BaseCard *drop_on_card);
  void dropFailedEvent(BaseCard *card);
  void clickEvent(BaseCard *card, int nx, int ny, int button);
  void doubleClickEvent(BaseCard *card, int nx, int ny, int button);
  void timerEvent(QTimerEvent *);
  void calcCardLayout();
  void resizeEvent(QResizeEvent* e);
  
private:

  void checkGameWon();
  bool altSuit(int suit1, int suit2);
  void setupScoring();

  Card** cards;
  Card** outlines;
  QwSpritePixmapSequence *cardImages, *outlineImages;
  SolUndo pending_undo, undo;

  GameStyle gstyle;
  DrawNum dnum;

  char game_won_card, game_won_frame;
  bool dont_dbl;

  int pile_d, pile_w, pile_h, play_d, pile_sep,
    scr, times_through_deck, 
    scr_on_ace_pile, scr_off_ace_pile, scr_on_play_pile, scr_through_deck,
    card_back_frame, outline_frame;

  QString background_image;

signals:
  void score(int);
  void gameWon(int);
  void newGameStarted(SolTable::GameStyle);
  void undoable(bool);

public slots:
  void _undo();
  void _deal();    // This starts a new game under Normal rules, under Vegas it just deals
  void _newgame(); // This starts a new game under both styles
};



class SolTableOptions : public QDialog {
  Q_OBJECT
public:
  SolTableOptions(SolTable*); 
  ~SolTableOptions();

private:
  SolTable *stbl;
  SolTable::GameStyle temp_gstyle;
  SolTable::DrawNum temp_dnum;
  int temp_cb, temp_ob;
  QString temp_back;

protected slots:
  void gs_clicked(int);
  void dn_clicked(int);
  void end_clicked(int);
  void cb_clicked(int);
  void ob_clicked(int);
  void backbut_clicked(int);
};

#endif

