//-----------------------------------------------------------------------------
//
// kmasaki - port of "masaki" from xlock
//

#ifndef __MASAKI_H__
#define __MASAKI_H__

#include <qtimer.h>
#include <qlist.h>
#include <qdialog.h>
#include <qlined.h>
#include "saver.h"

class kMasakiSaver : public kScreenSaver
{
	Q_OBJECT
public:
	kMasakiSaver( Drawable drawable );
	virtual ~kMasakiSaver();

	void setSpeed( int spd );
	void setLevels( int l );

protected:
	void readSettings();

protected slots:
	void slotTimeout();

protected:
	QTimer      timer;
	int         colorContext;

	int         speed;
	int			maxLevels;
};

class kMasakiSetup : public QDialog
{
	Q_OBJECT
public:
	kMasakiSetup( QWidget *parent = NULL, const char *name = NULL );

protected:
	void readSettings();

private slots:
	void slotSpeed( int );
	void slotLevels( int );
	void slotOkPressed();
	void slotAbout();

private:
	QWidget *preview;
	kMasakiSaver *saver;

	int			speed;
	int			maxLevels;
};

#endif

