//-----------------------------------------------------------------------------
//
// korca - port of "orca" from xlock
//

#ifndef __ORCA_H__
#define __ORCA_H__

#include <qtimer.h>
#include <qlist.h>
#include <qdialog.h>
#include <qlined.h>
#include "saver.h"

class kOrcaSaver : public kScreenSaver
{
	Q_OBJECT
public:
	kOrcaSaver( Drawable drawable );
	virtual ~kOrcaSaver();

	void setSpeed( int spd );
	void setLevels( int l );

protected:
	void readSettings();

protected slots:
	void slotTimeout();

protected:
	QTimer      timer;
	int         colorContext;

	int         speed;
	int			maxLevels;
};

class kOrcaSetup : public QDialog
{
	Q_OBJECT
public:
	kOrcaSetup( QWidget *parent = NULL, const char *name = NULL );

protected:
	void readSettings();

private slots:
	void slotSpeed( int );
	void slotLevels( int );
	void slotOkPressed();
	void slotAbout();

private:
	QWidget *preview;
	kOrcaSaver *saver;

	int			speed;
	int			maxLevels;
};

#endif

