/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** lightobj.cpp
*/
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 

#include "lightobj.h"

lightobj::lightobj(base *p,char *n) :
	csgobj(p,n)
{
	numtype = NUM_LIGHTOBJ;
}

lightobj::lightobj(base *p,char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,vs,vr,vt)
{
	numtype = NUM_LIGHTOBJ;
}

lightobj::lightobj(base *p,lightobj *lc) :
	csgobj(p,(csgobj*)lc)
{
	numtype = NUM_LIGHTOBJ;
}

lightobj::~lightobj()
{
}

void	lightobj::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("lightobj: %s\n",name);
}

int	lightobj::addToParent(base *parent)
{
	if(!parent) return -2;
	return parent->addChild(this);
}

double	lightobj::volume(int anim)
{
	return 0;
}



