/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** box.h
*/
#ifndef __BOX_H__
#define __BOX_H__

#include <stdio.h>

#include <classes.h>

class box : public csgobj
{
public:
	box(base *b=0,char *n="Untitled",texture *t=0);
	box(base *b,char *n,Vector3&,Vector3&,Vector3&);
	box(base *b,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	box(base *b,box *bc);
	~box();

	virtual int	addToParent(base *p);
	virtual int	removeFromParent();

	virtual base	*copy(base *p);

	virtual base	*searchName(const char *n);

	virtual int	exportPOV(FILE*,int,int,int anim);
	virtual void	dumpNames(int, int);

	virtual int	save(media*);
	virtual int	load(media*,int);

	virtual int	draw(view *,Matrix44,int anim);

	virtual int	calculate(int anim);

	virtual double	volume(int anim = 0);
};

#endif
