/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mesh.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "mesh.h"

mesh::mesh(base *p,char *n,texture *t) :
	nonsolid(p,n,t)
{
	tri tr;

	numtype = NUM_MESH;

	tr.p1[0] = -123;
	tr.p1[1] = 456;
	tr.p1[2] = 0.789;

	tlist.setErrorValue(tr);

	if(parent)
		addToParent(parent);
}

mesh::mesh(base *p,char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	nonsolid(p,n,vs,vr,vt)
{
	tri tr;

	numtype = NUM_MESH;

	tr.p1[0] = -123;
	tr.p1[1] = 456;
	tr.p1[2] = 0.789;

	tlist.setErrorValue(tr);

	if(parent)
		addToParent(parent);
}

mesh::mesh(base *p,char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	nonsolid(p,n,t,vs,vr,vt)
{
	tri tr;

	numtype = NUM_MESH;

	tr.p1[0] = -123;
	tr.p1[1] = 456;
	tr.p1[2] = 0.789;

	tlist.setErrorValue(tr);

	if(parent)
		addToParent(parent);
}

mesh::mesh(base *p,mesh *mc) :
	nonsolid(p,(nonsolid*)mc)
{
	numtype = NUM_MESH;

	tlist = mc->tlist;

	if(parent)
		addToParent(parent);
}

mesh::~mesh()
{
	removeFromParent();
}

base	*mesh::copy(base *p)
{
	return new mesh(p,this);
}

int	mesh::addToParent(base *p)
{
	if (!p) return(-2);

	parent = p;
	return p->addChild(this);
}

int	mesh::removeFromParent() 
{ 
	if (!parent) return(-2); 
	return parent->removeChild(this); 
}

void	mesh::dumpNames(int tab, int)
{
	printTab(stderr, tab);
	printf("mesh: %s\n",name);
}

void	mesh::addTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
	addTriangle(Vector3(x1,y1,z1),Vector3(x2,y2,z2),Vector3(x3,y3,z3));
}

void	mesh::setNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
	setNormal(Vector3(x1,y1,z1),Vector3(x2,y2,z2),Vector3(x3,y3,z3));
}

void	mesh::setNormal(Vector3 v1, Vector3 v2, Vector3 v3)
{
/*
	tri t = tlist.getCurrent();

	tlist.deleteCurrent();
	t.n1 = v1;
	t.n2 = v2;
	t.n3 = v3;
	t.smooth=1;
	tlist.insert(t);
*/
}

void	mesh::setSmooth(int)
{
/*
	tri t = tlist.getCurrent();

	tlist.deleteCurrent();
	t.smooth=1;
	tlist.insert(t);
*/
}

void	mesh::addTriangle(Vector3 v1, Vector3 v2, Vector3 v3)
{
	tri	t;

	t.p1 = v1;
	t.p2 = v2;
	t.p3 = v3;
	tlist += t;
}

void	mesh::removeTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
	Vector3 v1,v2,v3;

	v1 = Vector3(x1,y1,z1);
	v2 = Vector3(x2,y2,z2);
	v3 = Vector3(x3,y3,z3);
	removeTriangle(v1,v2,v3);
}

void	mesh::removeTriangle(Vector3 v1, Vector3 v2, Vector3 v3)
{
	int	i;

	for(i = 0;i < tlist.length();i++)
	{
		if((tlist[i].p1 == v1) && (tlist[i].p2 == v2) && (tlist[i].p3 == v3))
		{
			tlist.deleteAt(i);
			return;
		}
	}
}

int	mesh::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	long		l = tlist.length();
	int		i;
	tri		t;

	if(isFlag(NO_EXPORT)) return 0;

	if(l > 0)
	{
		printTab(fp,tab);
		fprintf(fp,"// Objectname = %s\n",name);
		printTab(fp,tab);
		fprintf(fp,"// Objecttype = mesh\n");
		printTab(fp,tab); 
		fprintf(fp,"mesh\n"); 
		printTab(fp,tab); 
		fprintf(fp,"{\n"); 
		for(i = 0;i < l;i++)
		{
			printTab(fp,tab);
			t = tlist[i];
			if(t.smooth==0)
			{
				fprintf(fp,"triangle {\n");
			}
			else
			{
				fprintf(fp,"smooth_triangle {\n");
			}
			if(t.smooth == 0)
			{
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p1[0],t.p1[1],t.p1[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p2[0],t.p2[1],t.p2[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p3[0],t.p3[1],t.p3[2]);
			}
			else
			{
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p1[0],t.p1[1],t.p1[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.n1[0],t.n1[1],t.n1[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p2[0],t.p2[1],t.p2[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.n2[0],t.n2[1],t.n2[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.p3[0],t.p3[1],t.p3[2]);
				printTab(fp,tab + tabsize); 
				fprintf(fp,"<%f, %f, %f>,\n",t.n3[0],t.n3[1],t.n3[2]);
			}
	
			dim::exportPOV(fp, tab + tabsize, tabsize,anim);

			fprintf(fp,"} \n");
		}
		// dim::exportPOV(fp,tab,tabsize);

		printTab(fp,tab);
		fprintf(fp,"}\n\n");
	}

	return 0;
}

int	mesh::save(media *m)
{
	struct tri	t;
	int		l = tlist.length();
	int		i;

	if(!m) return -1;
	setMedia(m);

	writeChunk("MESH");
	writeNameChunk(name);

	saveFlags(m);

	writeInt(l);
	for(i = 0;i < l;i++)
	{
		t = tlist[i];
		writeInt(t.smooth);
		writeVector(t.p1);
		writeVector(t.p2);
		writeVector(t.p3);
		if(t.smooth == 1)
		{
			writeVector(t.n1);
			writeVector(t.n2);
			writeVector(t.n3);
		}
	}		
	anim::save(m);
	dim::save(m);
	writeChunkLen();

	return 0;
}

int	mesh::load(media *m,int ll)
{
	tri	t;
	int	l,i,pos = m->tell();

	loadFlags(m,l);

	l = readInt();
	for(i = 0;i < l;i++)
	{
		t.smooth = readInt();
		t.p1 = readVector3();
		t.p2 = readVector3();
		t.p3 = readVector3();
		if(t.smooth == 1)
		{
			t.n1 = readVector3();
			t.n2 = readVector3();
			t.n3 = readVector3();
		}
		tlist+=t;
	}
	anim::load(m,ll - (m->tell()  - pos));
	dim::load(m,ll - (m->tell()  - pos));

	return 0;
}




