/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mapmodifier.cpp
*/
#include "mapmodifier.h"
#include <chunk.h>

mapmodifier::mapmodifier(textureBase *p):textureBase(MAPMODIFIER,p)
{
	phase=0;
	frequency=0;
	setName("Mapmodifier");
	setInfo("Mapmodifier");
	setSubItems(false);
}

mapmodifier::~mapmodifier()
{
}

void mapmodifier::updateInfo()
{
char buffer[1024];
	sprintf(buffer,"Frequency:%g  Phase:%g",frequency,phase);
	setInfo(buffer);
}

void mapmodifier::setFrequency(double f)
{
	frequency=f;
	updateInfo();
}

void mapmodifier::setPhase(double p)
{
	phase=p;
	updateInfo();
}

double mapmodifier::getPhase()
{
	return phase;
}


double mapmodifier::getFrequency()
{
	return frequency;
}

bool mapmodifier::canAdd(textureBase *tb)
{
	if (tb->getType()==MAPMODIFIER) return true;
	return false;
}

void mapmodifier::add(textureBase *tb)
{
mapmodifier *m=(mapmodifier *)tb;
	if (tb->getType()!=MAPMODIFIER) return ;
	frequency=m->getFrequency();
	phase=m->getPhase();	
	updateInfo();
}

bool mapmodifier::isEqual(textureBase *tb)
{
mapmodifier *m=(mapmodifier *)tb;
	if (tb->getType()!=MAPMODIFIER) return false;
	if (
		(frequency==m->getFrequency() ) &&
		(textureBase::isEqual(tb)==true) &&
		(phase==m->getPhase() )
	) return true;
	return false;	
}

int	mapmodifier::save(media *m)
{
chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving MapModifierModifier\n");
	#endif
	setMedia(m);

	writeChunk("MAPM");

	textureBase::save(m);
	
	ch.setMedia(m);
	ch.writeChunk("DATA");
		SD(frequency);
		SD(phase);
	ch.writeChunkLen();
	writeChunkLen();

	#ifdef DEBUG
		printf("MapModifier saved\n");
	#endif
	return 0;
}

int	mapmodifier::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	pos = m->tell(),len;

	#ifdef DEBUG
		printf("Loading MapModifier\n");
	#endif

	if(!m) return -1;

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&frequency, sizeof(double));
			m->read(&phase, sizeof(double));
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("MapModifier loaded\n");
	#endif
	updateInfo();
	return 0;
}

int mapmodifier::exportPOV(FILE *fp,int tab,int tabsize, int anim,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting MapModifer (POV)\n");
	#endif


	if (frequency!=0) {
		printTab(fp,tab+tabsize);
		fprintf(fp,"frequency %g\n",frequency);	
	}
	if (phase!=0) {
		printTab(fp,tab+tabsize);
		fprintf(fp,"phase %g\n",phase);	
	}
	
	#ifdef DEBUG
		printf("MapModifier exported (POV) saved\n");
	#endif
	return 0;
}

