/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normallist.cpp
*/
#include "normallist.h"

#include <misc.h>

static char	fnname[normalList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


normalList::normalList():chunk()
{
	fn=Checker;
	normals.append( new normal() );
	normals.append( new normal() );
}

void normalList::addNormalListEntry( normal *p)
{
	normals.insert( p );
}

void normalList::deleteNormalListEntry(int n)
{
	normals.deleteAt(n);
}

normal *normalList::getNormalListEntry(int n)
{
	return normals.at(n);
}

normalList::~normalList()
{
}

void normalList::clearNormalList()
{
	normals.empty();
}


void normalList::setNormalListFunction(FUNCTION f)
{
	fn=f;
}

int normalList::getNormalListFunction()
{
	return fn;
}

char *normalList::getNormalListFunctionName()
{
	return fnname[fn];
}

char *normalList::getNormalListFunctionNameList(int n)
{
	return fnname[n];
}

int	normalList::load(media *m,int l)
{
	int x,i;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;

	i=0;

	setMedia(m);
	
	#ifdef DEBUG
		printf("loading normalList\n");
	#endif

	m->read(&fn,4);
	m->read(&x,4);
	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"NRML",4) == 0) {
			addNormalListEntry( new normal() );
			getNormalListEntry(i)->load(m,len);
			read=true;
			i++;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("NormalList loaded\n");
	#endif
	return 0;
}

int	normalList::save(media *m)
{
int i;

	if(!m) return -1;
	#ifdef DEBUG
		printf("saving normalList\n");
	#endif
	setMedia(m);

	writeChunk("NRML");

	SI(fn);
	SI(normals.length());
	for (i=0;i<normals.length();i++) {
		normals[i]->save(m);
	}

	writeChunkLen();
	#ifdef DEBUG
		printf("NormalList saved\n");
	#endif
	return 0;
}

int normalList::exportPOV(FILE *fp,int tab,int tabsize,int a)
{
int i;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting normalList (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"%s\n",getNormalListFunctionName() );

	normals.getFirst()->exportPOV(fp,tab+tabsize,tabsize,a,false);
	for (i=1;i<normals.length();i++)  {
		normals[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}
	#ifdef DEBUG
		printf("PigmeltList exported (POV)\n");
	#endif
	return 0;
}

