/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentlist.cpp
*/
#include "pigmentlist.h"

#include <misc.h>

static char	fnname[pigmentList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


pigmentList::pigmentList():chunk() 
{
	fn=Checker;
	/*
	pigments.append( new pigment(0) );
	pigments.append( new pigment(2) );
	*/
	name=strdup("");
	info=strdup("no info avaiable");
}

char *pigmentList::getInfo()
{
	return info;
}

void pigmentList::addPigmentListEntry( pigment *p)
{
	pigments.insert( p );
}

void pigmentList::deletePigmentListEntry(int n)
{
	pigments.deleteAt(n);
}

pigment *pigmentList::getPigmentListEntry(int n)
{
	return pigments.at(n);
}

pigmentList::~pigmentList()
{
	if (name) free(name);
	if (info) free(info);
}

char *pigmentList::getName()
{
	return name;
}

void pigmentList::setName(char *n)
{
	if (name) free(name);
	name=strdup(n);
}

void pigmentList::clearPigmentList()
{
	pigments.empty();
}


void pigmentList::setPigmentListFunction(FUNCTION f)
{
	fn=f;
}

int pigmentList::getPigmentListFunction()
{
	return fn;
}

char *pigmentList::getPigmentListFunctionName()
{
	return fnname[fn];
}

char *pigmentList::getPigmentListFunctionNameList(int n)
{
	return fnname[n];
}

int	pigmentList::load(FILE *fp,int l)
{/*
	int x,i;
	char	chunk[4];
	bool 	read;
	int	len,pos = ftell(fp);

	if(!fp)
		return -1;
	i=0;
	#ifdef DEBUG
		printf("loading pigmentList\n");
	#endif
	fread(&fn,1,4,fp);
	fread(&x,1,4,fp);
	do {
		fread(chunk,1,4,fp);
		fread(&len,1,4,fp);
		read=false;

		if(strncmp(chunk,"PGMT",4) == 0) {
			addPigmentListEntry( new pigment(0) );
			getPigmentListEntry(i)->load(fp,len);
			read=true;
			i++;
		}
		if (read==false) { fseek(fp,len,SEEK_CUR); }
	} while (ftell(fp)< (pos+l) );
	fseek(fp,pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("PigmentList loaded\n");
	#endif*/
	return 0;
}

int	pigmentList::save(FILE *fp)
{/*
int i;

	if(!fp) return -1;
	#ifdef DEBUG
		printf("saving pigmentList\n");
	#endif
	setFile(fp);

	writeChunk("PIGL");

	SI(fn);
	SI(pigments.length());
	for (i=0;i<pigments.length();i++) {
		pigments[i]->save(fp);
	}

	writeChunkLen();
	#ifdef DEBUG
		printf("PigmentList saved\n");
	#endif*/
	return 0;
}

int pigmentList::exportPOV(FILE *fp,int tab,int tabsize,int a)
{
int i;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting pigmentList (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"%s\n",getPigmentListFunctionName() );

	pigments.getFirst()->exportPOV(fp,tab+tabsize,tabsize,a,false);
	for (i=1;i<pigments.length();i++)  {
		pigments[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}
	#ifdef DEBUG
		printf("PigmeltList exported (POV)\n");
	#endif
	return 0;
}

