/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturelibrary.cpp
*/
#include "texturelibrary.h"

#include <misc.h>


TextureLibrary::TextureLibrary():textureBase(TEXTURELIBRARY)
{
	num=0;

	setParent(NULL);
	setName("Texturelibrary");
	setInfo("");
	setSubItems(true);

}

TextureLibrary::~TextureLibrary()
{
}

bool TextureLibrary::canAdd(textureBase *tb)
{
int t;
	if(!tb) return false;
	t=tb->getType();
	return true;
/*
	if (
		(t==TEXTURELIBRARY)||
		(t==TEXTUREBOOK)||
		(t==TEXTURE)
	) return true;
	return false;
*/
}

void TextureLibrary::add(textureBase* tb)
{
	if (!tb) return;
	if (canAdd(tb)==false) return;

	if (tb->getType()==TEXTURELIBRARY) {
		insertLibrary( (TextureLibrary *)tb );
		return;
	}
	addElement(tb,NULL);
}

void TextureLibrary::insertLibrary(TextureLibrary *tlib)
{
textureBase*tb;
	if (!tlib) return;
	tb=tlib->getFirstElement();
	while (tb!=NULL) {
		add(tb);
		tb=tlib->getNextElement();
	}	
}

void TextureLibrary::addElement(textureBase *what,textureBase *where)
{
int t=-1;
	if (what==NULL) return;
	if (canAdd(what)==false) return;
#ifdef DEBUG
	printf("Adding to Library (l=%d)\n",booklist.length());
#endif
	what->setParent(this);
        if ((what->getType()==TEXTURE)||(what->getType()==TEXTUREBOOK)) {
		booklist.append(what);
		return;
	} else {
		texture *t=new texture(this);
		t->add(what);
		add(t);
		return;
	}
}

textureBase* TextureLibrary::getFirstElement()
{
	num=0;
	if (booklist.length()==0) return NULL;
#ifdef DEBUG
	printf("Getting First TLibrary-Element (l=%d)\n",booklist.length() );
#endif
	return booklist[0];

}


textureBase* TextureLibrary::getNextElement()
{
	num++;
	if (num>=booklist.length() ) return NULL;

#ifdef DEBUG
	printf("Getting Next TLibrary-Element (l=%d)\n",booklist.length() );
#endif
	return booklist[num];
	
}



void TextureLibrary::remove(textureBase *tb)
{
int i;
	for (i=0;i<booklist.length();i++) {
		if (tb->isEqual(booklist[i]) ) {
			booklist.deleteAt(i);			
			i=booklist.length()+1;
		}
	}
}


texture *TextureLibrary::findTexture(const char *n)
{
int i;

	printf("FINDING:%s\n",n);

	for (i=0;i<booklist.length();i++) {
		TextureBook *tb=(TextureBook*)booklist[i];
		texture *te=(texture *)tb->findTexturePath(n);
		if (te!=NULL) return te;
	}
	return NULL;
}



texture *TextureLibrary::findTextureStruct(texture *t)
{
        int i;

	for (i=0;i<booklist.length();i++) {
		textureBase *tb=booklist[i];
		if (tb->getType()==TEXTUREBOOK) {
			textureBase *te=((TextureBook *)tb)->findTextureStruct(t);
			if (te!=NULL) return (texture *)te;
		} else {
			texture *tx=(texture *)tb;
			if (t->isEqual(tx)==true) return tx;
		}
	}
		

	getFirstElement()->add(t);

	return t;
}

texture *TextureLibrary::findTexturePath(const char *n)
{
int i;
	char		buffer[1024];
	char		*cp;

#ifdef DEBUG
	printf("                      Searching Texturepath in Lib : %s\n",n);
#endif
	if(n == 0) return 0;

	strcpy(buffer,n);
	cp=strrchr(buffer,'/');
	if (cp) {
		*cp=0;
		cp++;
	}
	if (!cp) {
		for (i=0;i<booklist.length();i++) {		
			if (booklist[i]->getType()==TEXTURE) {
				if (!(strcmp(booklist[i]->getName(),buffer))) return (texture *)booklist[i];
			}
		}
		return 0;	
	}

	for (i=0;i<booklist.length();i++) {
		TextureBook *tb=(TextureBook*)booklist[i];
		if (!(strcmp(tb->getName(),cp))) {			
	                texture *te=(texture *)tb->findTexturePath(buffer);
			if (te!=NULL) return te;
#ifdef DEBUG
	printf("                       %s  -> %s\n",cp,tb->getName());
#endif
		}
	}
	return NULL;
}

int	TextureLibrary::load(media *m,int l)
{

	char		chunk[4];
	bool	 	read;
	int		len,pos = m->tell();

	if(!m)
		return -1;

	setMedia(m);
	#ifdef DEBUG
		printf("loading Texturelibrary...\n");
	#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"TXTB",4) == 0) {
			TextureBook	*tb;
			addElement((tb = new TextureBook(this)),NULL);
			tb->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TXTR",4) == 0) {
			texture *t;
			addElement((t = new texture(this)),NULL);
			t->load(m,len);
			read=true;
		}
	if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("Texturelibrary loaded\n");
	#endif

	return 0;
}

int	TextureLibrary::load(media *m)
{

	char		chunk[4];
	char		dummy[4];
	bool	 	read;
	int		len;

	if(!m) return -1;

	setMedia(m);
	#ifdef DEBUG
		printf("loading Texturelibrary from 3DDS !...\n");
	#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;



		if(strncmp(chunk,"TXTL",4) == 0) {
			load(m,len);		
			return 0;
		}
		if(strncmp(chunk,"FORM",4) == 0) {
			printf("got FORM\n");
			m->read(dummy,4);		
			if ((strncmp(dummy,"3DDS",4))) return -1;
			read=true;
		}

		if (read==false) {
#ifdef DEBUG
				printf("Skipping chunk (length=%d)\n",len);
#endif
				m->seek(len,SEEK_CUR);
		}

	} while (m->tell()!=-1 );

#ifdef DEBUG
		printf("Texturelibrary from 3DDS loaded\n");
#endif

	return 0;
}



int	TextureLibrary::save(media *m)
{

int i;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving Texturelibrary \n");
	#endif
	setMedia(m);

	writeChunk("TXTL");
	for (i=0;i<booklist.length();i++) booklist[i]->save(m);
	writeChunkLen();

	#ifdef DEBUG
		printf("Texturelibrary saved\n");
	#endif

	return 0;
}


int	TextureLibrary::saveLib(media *m)
{

int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving only Texturelibrary \n");
	#endif
	setMedia(m);
	ch.setMedia(m);
	ch.writeChunk("FORM");

	m->write("3DDS",4);

	writeChunk("TXTL");
	for (i=0;i<booklist.length();i++) booklist[i]->save(m);
	writeChunkLen();

	ch.writeChunkLen();
	#ifdef DEBUG
		printf("only Texturelibrary saved\n");
	#endif

	return 0;
}

int	TextureLibrary::exportPOV(FILE *fp,int tab,int tabsize, int a,bool dummy)
{
int i;
	for (i=0;i<booklist.length();i++) {
		booklist[i]->exportPOV(fp,tab,tabsize,a,true);
	}	
	return 0;
}