/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** preferencedialog.h
*/
#ifndef __PREFDIALOG_H__
#define __PREFDIALOG_H__


#include "../texture/previewwidget.h"
#include "../misc/image.h"
#include "../widgets/getfilewidget.h"
#include "../misc/preferences.h"

#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qtabdialog.h>
#include <qpushbutton.h>
//#include <qcombo.h>
#include <qcheckbox.h>
#include <qcolor.h>
//#include <qlistbox.h>
//#include <qmultilinedit.h>
#include <qgroupbox.h>

#include <kcolorbtn.h>



class PreferencesDialog : public QTabDialog
{
Q_OBJECT
protected:
	QWidget		*pathpage;
	QWidget		*editorpage,*renderpage,*screenpage;

	GetFileWidget	*TexturePathWidget, *TempPathWidget, *ImagePathWidget;
	GetFileWidget	*BumpMapPathWidget, *AnimationPathWidget, *DataPathWidget;
	GetFileWidget	*heightfieldPathWidget, *fontPathWidget, *imageMapPathWidget;

	QLabel		*TexturePathLabel, *TempPathLabel, *ImagePathLabel;
	QLabel		*BumpMapPathLabel, *AnimationPathLabel, *DataPathLabel;
	QLabel		*heightfieldPathLabel, *fontPathLabel, *imageMapPathLabel;

	KColorButton	*GridColor, *XAxisColor, *YAxisColor, *ZAxisColor;
	KColorButton	*BackgroundColor, *LineColor, *SelectedLineColor;
	KColorButton	*BlobColor,*BoxColor, *LetterXColor, *LetterYColor;
	KColorButton	*LetterZColor;
	QLabel		*GridColorLabel, *XAxisColorLabel, *YAxisColorLabel;
	QLabel		*ZAxisColorLabel, *BackgroundColorLabel, *LineColorLabel;
	QLabel		*SelectedLineColorLabel, *BlobColorLabel, *BoxColorLabel;
	QLabel		*LetterXColorLabel, *LetterYColorLabel, *LetterZColorLabel;
	
	QCheckBox	*DrawAxisCheckBox;

	GetFileWidget	*RenderProgram, *RenderSmallPreviewProgram;
	GetFileWidget	*RenderPreviewProgram;
	QComboBox	*RenderParams,*RenderSmallPreviewParams;
	QComboBox 	*RenderPreviewParams;		

	QLineEdit	*RenderPreviewPriority, *RenderSmallPreviewPriority;

	QGroupBox	*render1, *render2, *render3;

	QLabel		*RenderProgramLabel;	

	QLabel		*lscreensize,*lresolution;
	QLineEdit	*screenwidth,*screenheight;
	QLineEdit	*reswidth,*resheight;

	QLabel		*lgridspace_xy,*lgridspace_xz,*lgridspace_zy;
	QLineEdit	*gridspace_xy,*gridspace_xz,*gridspace_zy;
	
	QLabel		*lgridlines_xy,*lgridlines_xz,*lgridlines_zy;
	QLineEdit	*gridlines_xy,*gridlines_xz,*gridlines_zy;
	
	QCheckBox	*grid_xy,*grid_xz,*grid_zy;
	
	Preferences	prefs;

public:
	PreferencesDialog(QWidget *parent);
	~PreferencesDialog();

signals:
	void	update();

protected slots:
	void	Apply();
	void	Cancel();
	
	void	paintEvent(QPaintEvent*);
};

#endif



