/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** comm.cpp
*/
#include "comm.h"
#include "comm.moc"

#include <stdio.h>
#include <stdlib.h>

Comm::Comm() :
	QObject(), com("")
{
#ifdef USE_KPROCESS
	nr = 0;
	nw = 0;
	buffer[0] = 0;
	buffer[1] = 0;
	buffer[2] = 0;
	buffer[3] = 0;
	buffer[4] = 0;
	buffer[5] = 0;
	buffer[6] = 0;
	buffer[7] = 0;

	connect(&proc,SIGNAL(receivedStdout(KProcess*,char*,int)),
		this,SLOT(receivedStdout(KProcess*,char*,int)));
#else
	pipe(pipefd);
	pipe(pipefd + 2);

	pid = 0;
#endif
}

Comm::~Comm()
{
#ifdef USE_KPROCESS
	int	n;

	for(n = 0;n < 8;n++)
	{
		if(buffer[n])
		{
			free(buffer[n]);
			buffer[n] = 0;
		}
	}
#else
	close(pipefd[0]);
	close(pipefd[1]);
	close(pipefd[2]);
	close(pipefd[3]);
#endif
}

int	Comm::start(char *sc,int time,int start,int end,int stepsize)
{
	char	sr[8],sw[8],st[12],ss[12],se[12],sss[12];

#ifdef USE_KPROCESS
	int	n;

	for(n = 0;n < 8;n++)
	{
		if(buffer[n])
		{
			free(buffer[n]);
			buffer[n] = 0;
		}
	}
	nr = 0;
	nw = 0;
#endif
	sprintf(sr,"%i",pipefd[2]);
	sprintf(sw,"%i",pipefd[1]);
	sprintf(st,"%i",time);
	sprintf(ss,"%i",start);
	sprintf(se,"%i",end);
	sprintf(sss,"%i",stepsize);

#ifdef USE_KPROCESS
	proc.clearArguments();

	proc << sc;
	proc << sr;
	proc << sw;
	proc << st;
	proc << ss;
	proc << se;
	proc << sss;

	proc.start(KProcess::DontCare,(KProcess::Communication)(KProcess::Stdout | KProcess::Stdin));
//	proc.start(KProcess::DontCare,KProcess::Stdout);
//	proc.start(KProcess::DontCare,KProcess::Stdin);
#else

	memset(buffer,0,sizeof(buffer));

	switch((pid = fork()))
	{
		case 0: // child process
			execlp(sc,sc,sr,sw,st,ss,se,sss,(char*)0);
			printf("Error execlp\n");
			exit(3);
		case -1: // error fork
			printf("Error fork\n");
			pid = 0;

			return -1;
		break;
		default:
			// den lesekanal nonblocking setzen
			fcntl(pipefd[0],F_SETFL,O_NONBLOCK);
			fcntl(pipefd[3],F_SETFL,O_NONBLOCK);
	}
#endif

	return 0;
}

int	Comm::stop()
{
#ifdef USE_KPROCESS
	proc.kill();
#else
	if(pid > 0)
	{
		int	i,status;

		kill(pid,9);
		for(i = 0;i < 10000 || waitpid(pid,&status,WNOHANG) == 0;i++);
		if(i == 10000 || !WIFEXITED(status))
			return -1;
	}
#endif
	return 0;
}

int	Comm::read(char *s)
{
	int	i = 0;

#ifdef USE_KPROCESS
	if(buffer[nr])
	{
		fprintf(stderr,"Copy buffer #%i [%s]\n",nr,buffer[nr]);
		strcpy(s,buffer[nr]);
		free(buffer[nr]);
		buffer[nr] = 0;
		nr = (nr + 1) % 8;
	
		return strlen(s);
	}
	//fprintf(stderr,"Nothing to copy!\n");
#else
	char	tbuffer[256];

	s[0] = 0;

	i = ::read(pipefd[0],tbuffer,sizeof(tbuffer) - 1);
	if(i > 0)
	{
		tbuffer[i] = 0;
		strcat(buffer,tbuffer);
	}

	if(strchr(buffer,'\n') && (i = strchr(buffer,'\n') - buffer) < (int)sizeof(buffer))
	{
		strncpy(tbuffer,buffer,i + 1);
		tbuffer[i + 1] = 0;
		memmove(buffer,buffer + i + 1,strlen(buffer) - i);
		memset(buffer + strlen(buffer),0,sizeof(buffer) - strlen(buffer));

		strcpy(s,tbuffer);

		return i;
	}
#endif

	return 0;
}

int	Comm::write(char *s)
{
#ifdef USE_KPROCESS
	return proc.writeStdin(s,strlen(s));
#else
	return ::write(pipefd[3],s,strlen(s));
#endif
}

int	Comm::isRunning()
{
#ifdef USE_KPROCESS
	return proc.isRunning();
#else
	int	status;

	return (waitpid(pid,&status,WNOHANG) == 0);
#endif
}

#ifdef USE_KPROCESS
void	Comm::receivedStdout(KProcess *,char *bu,int l)
{
	if(buffer[nw] != 0)
	{
		fprintf(stderr,"Lost Buffer\n");
		return;
	}
	buffer[nw] = (char*)malloc(l + 1);
	strncpy(buffer[nw],bu,l);
	//buffer[nw][l] = 0;
	fprintf(stderr,"Received Buffer: [%s] (%i,%i)\n",buffer[nw],nw,nr);

	nw = (nw + 1) % 8;
}
#endif
