/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** drag3dds.cpp
*/

#include "drag3dds.h"
#include "drag3dds.moc"

#include <objects.h>

#define NUMTYPES	3

static const char	*formatmap[NUMTYPES] =
			{
				"3dds/texture",
				"3dds/modell",
				"3dds/texturedmodell"
			};

Drag3DDS::Drag3DDS(const char *mimetype,QWidget *dragSource,const char *name) :
	QStoredDrag(mimetype,dragSource,name)
{
}

const char	*Drag3DDS::format(int i) const
{
	if(i < 0 || i >= NUMTYPES)
		return 0;

	return formatmap[i];
}


bool		Drag3DDS::encode(textureBase *tb)
{
	int		error;
	QByteArray	data;
	media		*m;
	world		x;

	if((m = new media()) == 0)
		return FALSE;

	//error = x.save3DDS(m,t);
	error=tb->save(m);

	if(error == 0)
	{
		data.duplicate((const char*)m->data(),m->size());
		setEncodedData(data);
	}

	delete m;

	return error;
}

bool		Drag3DDS::encode(base *b)
{
	world		x;
	int		error;
	QByteArray	data;
	media		*m;

	if((m = new media()) == 0)
		return FALSE;

	error = x.save3DDS(m,b);

	if(error == 0)
	{
		data.duplicate((const char*)m->data(),m->size());
		setEncodedData(data);
	}

	delete m;

	return error;
}

bool		Drag3DDS::canDecode(QDragMoveEvent *e,const char *format)
{
	return e->provides(format);
}

bool		Drag3DDS::decode(QDropEvent *e,base **bp,const char *format)
{
	world 		x;
	QByteArray	data = e->data(format);

	if(data.size() < 1)
	{
		return FALSE;
	}

	e->accept();

	media		*m = new media();

	m->write(data.data(),data.size());
	m->seek(0,SEEK_SET); // auf Anfang zurck setzen

	if(x.load3DDS(m,bp) == 0)
	{
		((world*)*bp)->setParent(0);
	}
	else
	{
		delete m;

		return FALSE;
	}

	delete m;
	
	return TRUE;
}

bool		Drag3DDS::decode(QDragMoveEvent *e,textureBase **tp,const char *format)
{
	world 		x;
	QByteArray	data = e->data(format);
	textureBase	*t;
	int		l;
	char		chunk[4];

	if(data.size() < 1)
	{
		return FALSE;
	}

	e->accept();

	media		*m = new media();

	m->write(data.data(),data.size());
	m->seek(0,SEEK_SET); // auf Anfang zurck setzen


	m->read(&chunk,4);
	m->read(&l,4);

	if (!(strncmp(chunk,"COLL",4))) { t=new colorList(NULL); }
	if (!(strncmp(chunk,"BITM",4))) { t=new bitmapmodifier(NULL); }
	if (!(strncmp(chunk,"PATM",4))) { t=new patternmodifier(NULL); }
	if (!(strncmp(chunk,"TURB",4))) { t=new Turbulence(NULL); }
	if (!(strncmp(chunk,"TRNS",4))) { t=new Transformations(NULL); }
	if (!(strncmp(chunk,"FNSH",4))) { t=new finish(NULL); }
	if (!(strncmp(chunk,"MAPM",4))) { t=new mapmodifier(NULL); }
	if (!(strncmp(chunk,"COLR",4))) { t=new color(NULL); }
	if (!(strncmp(chunk,"PGMT",4))) { t=new pigment(NULL); }
	if (!(strncmp(chunk,"TXTR",4))) { t=new texture(NULL); }	
	if (!(strncmp(chunk,"IMGM",4))) { t=new imageMap(NULL); }	
	if (!(strncmp(chunk,"BMPM",4))) { t=new bumpMap(NULL); }	
	if (!(strncmp(chunk,"NRML",4))) { t=new normal(NULL); }	
	if (!(strncmp(chunk,"INTE",4))) { t=new interior(NULL); }	
	if (!(strncmp(chunk,"TXTB",4))) { t=new TextureBook(NULL); }
	if (!(strncmp(chunk,"COLE",4))) { t=new colorEntry(NULL); }
	if (!(strncmp(chunk,"COLM",4))) { t=new colorMap(NULL); }	
	if (!(strncmp(chunk,"DENS",4))) { t=new Density(NULL); }


	if(t->load(m,l) == 0)
	{
		*tp = t;
	}
	else
	{
		delete m;

		return FALSE;
	}

	delete m;
	
	return TRUE;

}


bool		Drag3DDS::decode(QDropEvent *e,textureBase **tp,const char *format)
{
	world 		x;
	QByteArray	data = e->data(format);
	textureBase	*t;
	int		l;
	char		chunk[4];

	if(data.size() < 1)
	{
		return FALSE;
	}

	e->accept();

	media		*m = new media();

	m->write(data.data(),data.size());
	m->seek(0,SEEK_SET); // auf Anfang zurck setzen


	m->read(&chunk,4);
	m->read(&l,4);

	if (!(strncmp(chunk,"COLL",4))) { t=new colorList(NULL); }
	if (!(strncmp(chunk,"BITM",4))) { t=new bitmapmodifier(NULL); }
	if (!(strncmp(chunk,"PATM",4))) { t=new patternmodifier(NULL); }
	if (!(strncmp(chunk,"TURB",4))) { t=new Turbulence(NULL); }
	if (!(strncmp(chunk,"TRNS",4))) { t=new Transformations(NULL); }
	if (!(strncmp(chunk,"FNSH",4))) { t=new finish(NULL); }
	if (!(strncmp(chunk,"MAPM",4))) { t=new mapmodifier(NULL); }
	if (!(strncmp(chunk,"COLR",4))) { t=new color(NULL); }
	if (!(strncmp(chunk,"PGMT",4))) { t=new pigment(NULL); }
	if (!(strncmp(chunk,"TXTR",4))) { t=new texture(NULL); }	
	if (!(strncmp(chunk,"IMGM",4))) { t=new imageMap(NULL); }	
	if (!(strncmp(chunk,"BMPM",4))) { t=new bumpMap(NULL); }	
	if (!(strncmp(chunk,"NRML",4))) { t=new normal(NULL); }	
	if (!(strncmp(chunk,"INTE",4))) { t=new interior(NULL); }	
	if (!(strncmp(chunk,"TXTB",4))) { t=new TextureBook(NULL); }
	if (!(strncmp(chunk,"COLE",4))) { t=new colorEntry(NULL); }
	if (!(strncmp(chunk,"COLM",4))) { t=new colorMap(NULL); }	
	if (!(strncmp(chunk,"DENS",4))) { t=new Density(NULL); }

	


	if(t->load(m,l) == 0)
	{
		*tp = t;
	}
	else
	{
		delete m;

		return FALSE;
	}

	delete m;
	
	return TRUE;
}






