/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** renamedialog.cpp
*/
#include "renamedialog.h"
#include "renamedialog.moc"

#include <klocale.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


RenameDialog::RenameDialog(QWidget *parent,char *name) :
	QDialog(parent,name,true)
{
	txt=strdup(name);
	old=strdup(name);

	label=new QLabel(this);
	label->setText("new:");

	line=new QLineEdit(this);
	line->setText(txt);

	ok=new QPushButton(this);
	ok->setText("Okay");
	ok->setAutoDefault(true);

	cancel=new QPushButton(this);
	cancel->setText("Cancel");

	connect(ok,SIGNAL(clicked()),this,SLOT(okayPressed() ));
	connect(cancel,SIGNAL(clicked()),this,SLOT(cancelPressed() ));
	connect(line,SIGNAL(returnPressed()),this,SLOT(okayPressed() ));

}

char *RenameDialog::exec()
{
	setGeometry(QCursor::pos().x(),QCursor::pos().y(),300,70);
	QDialog::show();
	if (result()==1) return txt;
	else return old;
}

RenameDialog::~RenameDialog()
{
	if (txt) free(txt);
	if (old) free(old);
}

void RenameDialog::okayPressed()
{
	if (!(strchr(line->text(),'/'))) {
		txt=strdup(line->text());
		QDialog::done(1);
	}
}

void RenameDialog::cancelPressed()
{
	QDialog::done(-1);
}


void RenameDialog::setGeometry(int a,int b,int w,int h)
{
int x,y;
QSize qs;

	y=5;
	qs=label->sizeHint();
	x=qs.width();
	label->setGeometry(5,y,x,25);
	line->setGeometry(5+x,y,w-x-10,25);
	line->setEnabled(true);
	y+=30;

	cancel->setGeometry(w-50,y,45,25);
	ok->setGeometry(w-100,y,45,25);

	QDialog::setGeometry(a,b,w,h);

}


