/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** spinbox.cpp
*/
#include "spinbox.moc"


SpinBox::SpinBox(QWidget *parent,char *name, double v) :
	QWidget(parent,name)
{
	buffer=(char *)malloc(255);
	value=v+1;
	value=value-1;
	sprintf(buffer,"%g",value);
	step=0.04;

	up=new QPushButton(this);
	up->setAutoRepeat(true);
	down=new QPushButton(this);
	down->setAutoRepeat(true);
	edit=new QLineEdit(this);
	qdv=new QDoubleValidator(this);	
	qdv->setRange(-10E6,10E6,6);
	edit->setValidator(qdv);
	edit->setText(buffer);

	topV=1E300;
	downV=-1E300;
	
	connect(up,SIGNAL(clicked()),this,SLOT(upClicked()) );
	connect(down,SIGNAL(clicked()),this,SLOT(downClicked()) );
	connect(down,SIGNAL(released()),this,SLOT(released()) );
	connect(up,SIGNAL(released()),this,SLOT(released()) );
	connect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );

	label=new QLabel(this);
	label->setText(name);
}

void SpinBox::setLabel(char *n)
{
	label->setText(n);
}

void SpinBox::newText(const char *n)
{
float f;
	buffer=edit->text();
	sscanf(buffer,"%f",&f);
	value=(double)f;
	emit changed();
}

void SpinBox::released()
{
	if (up->isDown()||down->isDown()) return;
	step=0.04;
}

void SpinBox::downClicked()
{
	disconnect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
	value-=step;
	if (value<=downV) value=downV;
	step=step+.4;
	sprintf(buffer,"%g",value);
	edit->setText(buffer);
	emit changed();
	connect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
}


void SpinBox::upClicked()
{
	disconnect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
	value+=step;
	if (value>=topV) value=topV;
	step=step+.4;
	sprintf(buffer,"%g",value);
	edit->setText(buffer);
	emit changed();
	connect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
}

void SpinBox::setGeometry(int x, int y, int w, int h)
{
int a;
	a=label->sizeHint().width();
	label->setGeometry(0,0,a,h);
	edit->setGeometry(a+5,0,w-15-a,h);		
	up->  setGeometry(w-9,0,       9,(int)h/2);
	down->setGeometry(w-9,(int)h/2,9,(int)h/2);
	QWidget::setGeometry(x,y,w,h);

}

SpinBox::~SpinBox()
{
	if (buffer) free(buffer);
}

double SpinBox::getValue()
{
	return (double)value;
}

void SpinBox::setEnabled(bool e)
{
	up->setEnabled(e);
	down->setEnabled(e);
	edit->setEnabled(e);
	label->setEnabled(e);
}

void SpinBox::setValue(double v)
{
	disconnect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
	value=v;
	sprintf(buffer,"%g",value);
	edit->setText(buffer);
	connect(edit,SIGNAL(textChanged(const char*)),this,SLOT(newText(const char *)) );
}

void SpinBox::DownTopValue(double a, double b)
{
	topV=b;
	downV=a;	
}