/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bumpmapWidget.cpp
*/
#include "bumpmapdialog.h"
#include "bumpmapdialog.moc"



BumpMapWidget::BumpMapWidget(QWidget *parent,bumpMap *b) :
	QWidget(parent,"Bumpmap")
{

	#ifdef DEBUG
	printf("Entering BumpMapWidget-Constructor\n");
	#endif
	
	bu=b;
	bmm=bu->getModifier();

	filewidget=new GetFileWidget(this,"File:",bu->getBumpMapFilename(),1);

	mapping=new QComboBox(this);
	mapping->insertItem("planar");
	mapping->insertItem("spherical");
	mapping->insertItem("(reserved#1)");
	mapping->insertItem("(reserved#2)");
	mapping->insertItem("donut/torus");
	mapping->setCurrentItem(bmm->getMapType() );	

	maplabel=new QLabel(this);
	maplabel->setText("Mapping:");

	once=new QCheckBox("Once",this);
	if (bmm->getOnce()==1) once->setChecked(true);
	else once->setChecked(false);

       	interpolate=new QComboBox(this);
	interpolate->insertItem("none");
	interpolate->insertItem("bilinear");
	interpolate->insertItem("normalized");
	switch(bmm->getInterpolate()) {
		case 0:interpolate->setCurrentItem(0);
		break;
		case 2:interpolate->setCurrentItem(1);
		break;
		case 4:interpolate->setCurrentItem(2);
		break;
	}

   	interpolatelabel=new QLabel("Interpolation:",this);

	bslabel=new QLabel("Depth:",this);
	bumpsize=new SpinBox(this,"",bu->getBumpSize());

	uclabel=new QLabel("Use Color",this);
	usecolor = new QCheckBox(this);
	if (bu->getBumpUseColor()==true) usecolor->setChecked(true);
	else usecolor->setChecked(false);

	nlabel=new QLabel("Name:",this);
	name=new QLineEdit(this);
	name->setText(bu->getName() );

	active=new QCheckBox("Active",this);
	active->setChecked(bu->active() );


	#ifdef DEBUG
	printf("Leaving BumpMapWidget-Constructor\n");
	#endif	
}

BumpMapWidget::~BumpMapWidget()
{
}


void BumpMapWidget::getBumpMap()
{

	bu->setBumpMapFilename( (char *)filewidget->getFilename());
	bu->setBumpMapFiletype( (char *)filewidget->getImageType());
	bu->setName(name->text() );
	bu->setActive( active->isChecked(),NULL);
	if (usecolor->isChecked()) bu->setBumpUseColor();
	else bu->setBumpUseIndex();
	bu->setBumpSize(bumpsize->getValue());	

	bmm->setMapType(mapping->currentItem());
	if (once->isChecked()) bmm->setOnce();
	else bmm->unSetOnce();
	switch(interpolate->currentItem() ) {
		case 0: bmm->setInterpolate(0);
		break;
		case 1:bmm->setInterpolate(2);
		break;
		case 2:bmm->setInterpolate(4);
		break;
	}

	return bu;
}

void BumpMapWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	//int h=height();
	
	nlabel->setGeometry(10,10,40,25);
	name->setGeometry(55,10,150,25);

	active->setGeometry(220,10,60,25);

	filewidget->setGeometry(10,40,w-20,25);
	


	bslabel->setGeometry(10,70,55,25);
	bumpsize->setGeometry(70,70,70,25);

	uclabel->setGeometry(10,100,60,25);
	usecolor->setGeometry(75,100,15,25);	

	once->setGeometry(125,100,50,25);	

	maplabel->setGeometry(10,130,55,25);
	mapping->setGeometry(95,130,110,25);

	interpolatelabel->setGeometry(10,160,85,25);
	interpolate->setGeometry(95,160,110,25);	

	QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

BumpMapDialog::BumpMapDialog(QWidget *parent,bumpMap *b) :
	QDialog(parent,"BumpMapDialog",true)
{

	setCaption("BumpMap");

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new BumpMapWidget(this,b);

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );

	resize(300,220);
	setMinimumSize(300,220);
	setMaximumSize(300,220);
	
}

BumpMapDialog::~BumpMapDialog()
{
}


void BumpMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void BumpMapDialog::okayPressed()
{
	pw->getBumpMap();
	QDialog::done(1);
}

void BumpMapDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}


