/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** finishdialog.h
*/
#ifndef __FinishDialog_H__
#define __FinishDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include "../../3d/textures/finish.h"
#include "../misc/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>

#include "transformationswidget.h"
#include "turbulencewidget.h"


class FinishWidget : public QWidget
{
Q_OBJECT
protected:
	finish  *fi;

	TransformationsWidget *tw;
	TurbulenceWidget *tbw;
	
	QColor	qc;
	QCheckBox *active;
	QPushButton *transformations,*turbulence;
	QLineEdit		*name;
	TabWidget	*tab;

	QWidget *page1,*page2,*page3;

	KColorButton	*ambient;
	QLabel 	*ambientlabel,*namelabel;

	SpinBox	*diffuse,*brilliance;
	SpinBox	*phong,*phongsize,*specular,*roughness;
	SpinBox *reflection, *iridturb,*iridthick,*iridamount;
	QLabel *iridlabel;
	QCheckBox *metall;

public:

	FinishWidget(QWidget *p, finish *);
	~FinishWidget();

	void getFinish();
	
	int width();
	int height();

protected:
	void	paintEvent(QPaintEvent*);
protected slots:

	void transformationsPressed();
	void turbulencePressed();
};

//---------------------------------------------------------

class FinishDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton		*ok,*cancel;
	FinishWidget		*nw;


public:

	FinishDialog(QWidget *p, finish *);
	~FinishDialog();

protected:
	void	paintEvent(QPaintEvent*);

protected slots:
	void okayPressed();
	void cancelPressed();

};


#endif
