/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifierdialog_bak.cpp
*/
#include <qslider.h>
#include "patternmodifierdialog.h"
#include "patternmodifierdialog.moc"

#include <klocale.h>


//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


PatternModifierDialog::PatternModifierDialog(QWidget *parent,const char *name,patternmodifier *p) :
	QDialog(parent,name,true)
{

	modifier = p;

	r1=new QRadioButton("simple Turbulence",this);
	r2=new QRadioButton("Warp",this);
	r3=new QRadioButton("black Hole",this);

	switch(modifier->getMode()) {
		case 0:
		break;
		case 1:
			r1->setChecked(true);
		break;
		case 2:
			r2->setChecked(true);
		break;
		case 3:
			r3->setChecked(true);
		break;
	}

        ok = new QPushButton( "Ok", this ); 
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );        
	cancel = new QPushButton( "Cancel", this );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	scale=new VectorWidget(this,"Scaling");
	scale->setVector(modifier->getScale());

	rotate=new VectorWidget(this,"Rotatation");
	rotate->setVector(modifier->getRotate());

	translate=new VectorWidget(this,"Translation");
	translate->setVector(modifier->getTranslate());

	turbulence=new VectorWidget(this,"Turbulence");
	turbulence->setVector(modifier->getTurbulence());

	blackhole=new VectorWidget(this,"Black hole");
	blackhole->setVector(modifier->getBlackHole());
	
	repeat=new VectorWidget(this,"Repeat");
	repeat->setVector(modifier->getRepeat());


	repeatwarp=new VectorWidget(this,"Repeat");
	repeatwarp->setVector(modifier->getRepeatWarp());


	offsetwarp=new VectorWidget(this,"Offset");
	offsetwarp->setVector(modifier->getOffsetWarp());

	flipwarp=new VectorWidget(this,"Flip Warp");
	flipwarp->setVector(modifier->getFlipWarp());

	turbulencewarp=new VectorWidget(this,"Turbulence");
	turbulencewarp->setVector(modifier->getTurbulenceWarp());

	octaves=new SpinBox(this,"Octaves");
	octaves->setValue(modifier->getOctaves() );

	omega=new SpinBox(this,"Omega");
	omega->setValue(modifier->getOmega() );

	lambda=new SpinBox(this,"Lambda");
	lambda->setValue(modifier->getLambda() );

	fall_off=new SpinBox(this,"Fall off  ");
	fall_off->setValue(modifier->getFallOff() );

	strength=new SpinBox(this,"Strength");
	strength->setValue(modifier->getStrength() );

	blackholeradius=new SpinBox(this,"Radius  ");
	blackholeradius->setValue(modifier->getBlackHoleRadius() );

	inverse=new QCheckBox(this);
	inverselabel=new QLabel(this);
	inverselabel->setText("Inverse");
	warpselect=new QComboBox(this);
	warpselect->insertItem("Warp");
	warpselect->insertItem("Black hole");

	setGeometry(10,10,300,500);
	setMinimumSize(300,480);
	setMaximumSize(300,480);

	connect(r1,SIGNAL(pressed()),this,SLOT(radio1Pressed()));
	connect(r2,SIGNAL(pressed()),this,SLOT(radio2Pressed()));
	connect(r3,SIGNAL(pressed()),this,SLOT(radio3Pressed()));
	update();
}


void PatternModifierDialog::radio1Pressed()
{
	r2->setChecked(false);
	r3->setChecked(false);
	if (mode==1) mode=0;
	else mode=1;
	drawIt();
}
void PatternModifierDialog::radio2Pressed()
{
	r1->setChecked(false);
	r3->setChecked(false);
	if (mode==2) mode=0;
	else mode=2;	
	drawIt();
}
void PatternModifierDialog::radio3Pressed()
{
	r1->setChecked(false);
	r2->setChecked(false);
	if (mode==3) mode=0;
	else mode=3;
	drawIt();
}

void PatternModifierDialog::reject()
{
	done(-1);
}

void PatternModifierDialog::accept()
{
	
	modifier->setScale(scale->getVector());
	modifier->setRotate(rotate->getVector());
	modifier->setTranslate(translate->getVector());
	modifier->setTurbulence(turbulence->getVector());

	modifier->setBlackHole(blackhole->getVector());
	modifier->setRepeat(repeat->getVector());
	modifier->setRepeatWarp(repeatwarp->getVector());
	modifier->setOffsetWarp(offsetwarp->getVector());
	modifier->setFlipWarp(flipwarp->getVector());
	modifier->setTurbulenceWarp(turbulencewarp->getVector());


	modifier->setOctaves(octaves->getValue() );
	modifier->setOmega(omega->getValue() );
	modifier->setLambda(lambda->getValue() );


	modifier->setFallOff(fall_off->getValue() );
	modifier->setStrength(strength->getValue() );
	if (inverse->isChecked()==true) {
		modifier->setInverse(1);
	} else {
		modifier->setInverse(0);
	}
	modifier->setBlackHoleRadius(blackholeradius->getValue() );
	modifier->setMode(mode);

	done(0);
}


PatternModifierDialog::~PatternModifierDialog()
{
}

void PatternModifierDialog::drawIt()
{
int a,b;

	scale->setGeometry(5,5,80,120);
	rotate->setGeometry(105,5,80,120);
	translate->setGeometry(205,5,80,120);

	r1->setGeometry(5,130,120,25);
	r2->setGeometry(135,130,100,25);
	r3->setGeometry(205,130,100,25);

	a=-300;b=-300;
	
	turbulence->setGeometry(a,b,80,120);

	octaves->setGeometry(a,b,100,25);
	omega->setGeometry(a,b,100,25);
	lambda->setGeometry(a,b,100,25);

	blackhole->setGeometry(a,b,80,120);
	repeat->setGeometry(a,b,80,120);
	fall_off->setGeometry(a,b,120,25);	
	strength->setGeometry(a,b,120,25);
	blackholeradius->setGeometry(a,b,120,25);
	inverse->setGeometry(a,b,25,25);
	inverselabel->setGeometry(a,b,120,25);

	turbulencewarp->setGeometry(a,b,80,120);

	flipwarp->setGeometry(a,b,80,120);
	offsetwarp->setGeometry(a,b,80,120);
	repeatwarp->setGeometry(a,b,80,120);

	warpselect->setGeometry(a,b,80,25);	

	switch(mode) {
		case 0:
		break;
		case 1:
			turbulence->setGeometry(5,170,80,120);
			octaves->setGeometry(5,295,100,25);
			omega->setGeometry(110,295,100,25);
			lambda->setGeometry(5,325,100,25);
		break;
		case 2:
			flipwarp->setGeometry(5,170,80,120);
			offsetwarp->setGeometry(90,170,80,120);
			repeatwarp->setGeometry(175,170,80,120);
		break;
		case 3:
			blackhole->setGeometry(5,170,80,120);
			blackholeradius->setGeometry(120,170,120,25);
			fall_off->setGeometry(120,200,120,25);	
			strength->setGeometry(120,230,120,25);
			turbulencewarp->setGeometry(5,325,80,120);
			repeat->setGeometry(90,325,80,120);
			inverse->setGeometry(5,450,25,25);
			inverselabel->setGeometry(30,450,120,25);
		break;		
	}
}

void PatternModifierDialog::setGeometry(int x, int y, int w, int h)
{
	drawIt();
	ok->setGeometry( w-85,h-65, 70,30 );       
	cancel->setGeometry( w-85,h-95, 70,30 );
	QDialog::setGeometry(x,y,w,h);
}

		
