/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.h
*/
#ifndef __PigmentDialog_H__
#define __PigmentDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include <color.h>
#include "../../3d/textures/pigment.h"
#include "../misc/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>
/*
#include "colorwidget.h"
#include "transformationswidget.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "imagemapdialog.h"
#include "turbulencewidget.h"
#include "patternmodifierdialog.h"
*/

class TransformationsWidget; 	
class	TurbulenceWidget; 	
class	PatternModifierDialog;
class ColorListWidget;
class ColorMapWidget;
class ImageMapWidget;
class ColorWidget ;


class PigmentWidget : public QWidget
{
Q_OBJECT
protected:
	pigment  *pig;

	TabWidget		*tab;

	QColor qc;
	KColorButton		*cbt1;
	
	TransformationsWidget 	*tw;
	TurbulenceWidget 	*tbw;
	PatternModifierDialog 	*pmw;
	
	
	QWidget       		*pigmentmapwidget;
	QWidget       		*pigmentlistwidget;

	QCheckBox		*active;
	QButton			*addElement;
	QPopupMenu		*Elements;

	QPushButton		*transformations,*turbulence,*pattern;
	QLineEdit		*line1;
	
	QColor			quickColor;
	QLabel			*label1,*label2,*label3,*label4;
	QWidget			*emptywidget;
	
	list<QWidget *>			widgetlist;
	list<ColorListWidget *>		colorlistwidget;
	list<ColorMapWidget *>		colormapwidget;
	list<ImageMapWidget *>		imagemapwidget;
	list<ColorWidget *>		colorwidget;


public:

	PigmentWidget(QWidget *p, pigment *);
	~PigmentWidget();

	void getPigment();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void addPressed();
	void transformationsPressed();
	void turbulencePressed();
};

//----------------------------------------------------


class PigmentDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	PigmentWidget		*pw;

public:

	PigmentDialog(QWidget *p, pigment *);
	~PigmentDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
