/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** SlopeEntrywidget.cpp
*/
#include "slopeentrywidget.h"
#include "slopeentrywidget.moc"




SlopeEntryWidget::SlopeEntryWidget(QWidget *parent,slopeEntry *s) :
	QWidget(parent,"SlopeEntryDialog")
{

	se=s;

	name=new QLineEdit(this);
	name->setText(se->getName());
	nameLabel=new QLabel("Name:",this);
	
	value=new SpinBox(this,"Value:",se->getSlopeNum());
	value->DownTopValue(0,1);

	heigh=new SpinBox(this,"Height:",se->getSlopeHeight());
	heigh->DownTopValue(-3,3);

	slope=new SpinBox(this,"Slope:",se->getSlope());
	slope->DownTopValue(-3,3);

	active=new QCheckBox("Active",this);
	active->setChecked(se->active() );

}

void SlopeEntryWidget::getSlopeEntry()
{
	se->setSlopeNum(value->getValue());
	se->setSlopeHeight(heigh->getValue());
	se->setSlope(slope->getValue());
	se->setName(name->text());
	se->setActive( active->isChecked(),NULL);
}

SlopeEntryWidget::~SlopeEntryWidget()
{
}

int SlopeEntryWidget::width()
{
	return 280;
}
int SlopeEntryWidget::height()
{
	return 100;
}

void SlopeEntryWidget::paintEvent(QPaintEvent* qp)
{
	//int w=width();
	//int h=height();
	
	nameLabel->setGeometry(10,10,50,25);
	name->setGeometry(65,10,150,25);
	active->setGeometry(220,10,60,25);

	value->setGeometry(10,40,100,25);
	heigh->setGeometry(10,70,100,25);
	slope->setGeometry(165,70,100,25);

	QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

SlopeEntryDialog::SlopeEntryDialog(QWidget *parent,slopeEntry *s) :
	QDialog(parent,"SlopeEntryDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new SlopeEntryWidget(this,s);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(pw->width(),pw->height()+30);
	setMinimumSize(pw->width(),pw->height()+40);
	setMaximumSize(pw->width(),pw->height()+40);
	
}

SlopeEntryDialog::~SlopeEntryDialog()
{
}


void SlopeEntryDialog::cancelPressed()
{
	QDialog::done(0);
}

void SlopeEntryDialog::okayPressed()
{
	pw->getSlopeEntry();
	QDialog::done(1);
}

void SlopeEntryDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);
	pw->setGeometry(0,0,w,h-35);
	QDialog::paintEvent(qp);
}