/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** sliderwidget.cpp
*/
#include "sliderwidget.moc"
#include <qslider.h>
#include <klocale.h>

#include <stdio.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


SliderWidget::SliderWidget(QWidget *parent,char *name,int v,int min,int max) :
	QWidget(parent,name)
{

	value=v;

	slider=new QSlider(this);

	slider->setRange(min,max);
	slider->setSteps(1,1);
	slider->setOrientation(QSlider::Horizontal);
	slider->setValue( v );

	label=new QLabel(name,this);
	valuel=new QLabel(this);
	
	connect(slider,SIGNAL(valueChanged(int)),this,SLOT(changed(int)) );	

}

SliderWidget::~SliderWidget()
{
}

void SliderWidget::changed(int x)
{
        QString buf;

	value=x;
	buf.setNum(value);
	valuel->setText(buf);

}

int SliderWidget::getValue()
{
	return value;
}

void SliderWidget::setValue(int v)
{
        QString buf;

	value=v;
	buf.setNum(value);
	valuel->setText(buf);
}

void SliderWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
        QString buf;
        QSize qs;

	buf.setNum(value);
	valuel->setText( buf);
        qs=label->sizeHint();

	label->setGeometry(0,0,qs.width(),h);
	slider->setGeometry(qs.width()+5,0,w-qs.width()-42,h-2);
	valuel->setGeometry(w-35,0,35,h);	

	QWidget::paintEvent(qp);

}
