/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** matmath.h
*/

#ifndef __MATMATH_H__
#define __MATMATH_H__

#include <stdio.h>
#include <math.h>

class Vector2;
class Vector3;
class Vector4;

class Matrix44
{
protected:

	double 	elements[4][4];

public:

	Matrix44(); 
	Matrix44(Matrix44 &);

	Matrix44	operator+(const Matrix44 &);
	Matrix44	operator-(const Matrix44 &); 
	Matrix44	operator-(); 
	Matrix44	operator*(const Matrix44 &);
	Matrix44 	operator*(const double &); 
	Matrix44 	&operator=(const Matrix44 &);
	Matrix44 	&operator+=(const Matrix44 &m);
	Matrix44 	&operator-=(const Matrix44 &m);
	Matrix44 	&operator*=(const Matrix44 &m);
	Matrix44	&operator*=(const double &d);
	double		&operator()(int,int); 
	double		operator()(int,int) const; 
	Matrix44	operator~();
	void		unify();
	Matrix44	&scaleVector(Vector3&);
	Matrix44	&transposeVector(Vector3&);
	Matrix44	&rotateVector(Vector3&);

	void		print()
	{
		int	x,y;

		for(y = 0;y < 4;y++)
		{
			for(x = 0;x < 4;x++)
				printf("%f\t",elements[y][x]);
			printf("\n");
		}
	}
};

class Vector4
{
	friend class Matrix44;
	friend class Vector3;
	friend class Vector2;
protected:
	double		elements[4];
 
public:
	Vector4(); 
	Vector4(double,double,double,double); 
	Vector4(const Vector4&); 
	Vector4(Vector3); 
	Vector4(Vector3,double); 
	Vector4(Vector2); 
	Vector4(Vector2,double,double); 

	Vector4		operator+(const Vector4 &) const; 
	Vector4		operator-(const Vector4 &) const; 
	Vector4 	operator*(const Matrix44 &) const; 
	Vector4 	operator*(const double &) const; 
	Vector4 	operator/(const double &) const; 
	Vector4		operator-() const; 
	Vector4 	&operator=(const Vector4 &); 
	Vector4 	&operator+=(const Vector4 &);
	Vector4 	&operator-=(const Vector4 &);
	Vector4		&operator*=(const Matrix44 &);
	Vector4		&operator*=(const double &);
	Vector4		&operator/=(const double &);
	double		&operator()(int); 
	double		&operator[](int); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector4 &);

	void		print()
	{
		printf("%f\t%f\t%f\t%f\n",elements[0],elements[1],elements[2],elements[3]);
	}
};


class Vector3
{
	friend class Vector4;
	friend class Vector2;
protected:
	double		elements[3];
 
public:
	Vector3(); 
	Vector3(double,double,double); 
	Vector3(Vector4); 
	Vector3(const Vector3&); 
	Vector3(Vector3&); 
	Vector3(Vector2); 
	Vector3(Vector2,double); 

	Vector3		operator+(const Vector3 &) const; 
	Vector3		operator-(const Vector3 &) const; 
	Vector3		operator-() const; 
	Vector3		operator*(const Vector3 &) const; 
	Vector3 	operator*(const double &) const; 
	Vector3 	operator/(const double &) const; 
	Vector3 	&operator=(const Vector3 &); 
	Vector3 	&operator+=(const Vector3 &m);
	Vector3 	&operator-=(const Vector3 &m);
	Vector3 	&operator*=(const Vector3 &m);
	Vector3		&operator*=(const double &d);
	Vector3		&operator/=(const double &d);
	int		operator==(const Vector3 &d);
	int		operator!=(const Vector3 &d);
	double		&operator()(int); 
	double		&operator[](int); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector3 &);

	double		distance(const Vector3&);
	double		distance(const Vector3&,const Vector3&);
	double		distance(const Vector3&,const Vector3&,const Vector3&);

	void		print()
	{
		printf("%f\t%f\t%f\n",elements[0],elements[1],elements[2]);
	}
};
	

class Vector2
{
	friend class Vector4;
	friend class Vector3;
protected:
	double		elements[2];
 
public:
	Vector2(); 
	Vector2(double,double); 
	Vector2(Vector4); 
	Vector2(Vector3); 
	Vector2(const Vector2&); 

	Vector2		operator+(const Vector2 &) const; 
	Vector2		operator-(const Vector2 &) const; 
	Vector2		operator-() const; 
	Vector2 	operator*(const double &) const; 
	Vector2 	operator/(const double &) const; 
	Vector2 	&operator=(const Vector2 &); 
	Vector2 	&operator+=(const Vector2 &m);
	Vector2 	&operator-=(const Vector2 &m);
	Vector2		&operator*=(const double &d);
	Vector2		&operator/=(const double &d);
	double		&operator()(int); 
	double		&operator[](int); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector2 &);

	void		print()
	{
		printf("%f\t%f\n",elements[0],elements[1]);
	}
};

#endif
