/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** media.h
*/
#ifndef __MEDIA_H__
#define __MEDIA_H__

/*
indent -st media2.cpp -bad -bap -bl -bli0 -npcs -psl -di16 -i8 -ci4 -lp -l80 -nbc
*/

#include <misc.h>

class media
{
protected:
	int	pos;
	int	data_size;
	void	*array;
	int	array_size;
	FILE	*fp;
	int	close;

public:
	media(FILE* f = 0);
	media(const char* fn);
	~media();

	int		read(void *buffer,int len);
	int		write(const void *buffer,int len);
	int		tell();
	int		seek(int dist,int how);
	int		eod();

	const void	*data() const;
	int		size();
};


#endif



