/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** simplelist.h
*/

#ifndef __SIMPLELIST__
#define __SIMPLELIST__

#include <stdio.h>
#include <stdlib.h>

template<class type>
class simplelist
{
protected:
	int		size;
	type		*lptr;
	type		errorvalue;

public:
	simplelist();
	simplelist(type errorvalue); 
	simplelist(const simplelist<type>&);
	virtual ~simplelist();

	void			setErrorValue(const type ev);
	type			getErrorValue();

	virtual int		append(const type l);
	int			deleteAt(int);				// Element an Position lschen

	int			operator+=(const type l);			// Element anfgen
	int			operator+=(const simplelist<type>);		// Liste anfgen
	simplelist<type>	&operator=(const simplelist<type>);		// gleich
	simplelist<type>	operator+(const type) const;		// plus
	simplelist<type>	operator+(const simplelist<type>) const;	// plus

	type			&getFirst();
	type			&getLast();
	type			&at(int);
	const type		at(int) const;
	type			&operator[](int);
	const type		operator[](int) const;
	type			*operator()(int) const;
	type			*atPtr(int) const;

	int			isEmpty() const;				// prft ob die Liste leer ist, -1 bei Fehler
	virtual void		empty();				// leert die Liste

	int			length() const;				// Anzahl der Elemente

};


template<class type>
simplelist<type>::simplelist()
{
	size=0;
	lptr=0;
}

template<class type>
simplelist<type>::simplelist(const simplelist<type> &lc)
{
	size = lc.size;;

	lptr = (type*)malloc(size * sizeof(type));
	memcpy(lptr,lc.lptr,size * sizeof(type));

	errorvalue = lc.errorvalue;
}

template<class type>
simplelist<type>::~simplelist()
{
	empty();
}

template<class type>
void		simplelist<type>::setErrorValue(const type ev)
{
	errorvalue = ev;
}

template<class type>
type		simplelist<type>::getErrorValue()
{
	return errorvalue;
}

template<class type>
void		simplelist<type>::empty()
{
	if(lptr != 0)
	{
		free(lptr);
		lptr = 0;
		size = 0;
	}
}

template<class type>
int	simplelist<type>::deleteAt(int n)
{
	int		i;

	if(n < 0 || n >= size)
		return -1;

	for(i=n;i<size;i++)
		lptr[i]=lptr[i+1];
	size--;

	lptr=(type*)realloc(lptr,size * sizeof(type));

	if(lptr == 0 && size != 0)
	{
		// fehler

		size = 0;

		return -2;
	}

	return 0;
}

template<class type>
int	simplelist<type>::operator+=(const type l)
{
	return append(l);
}

template<class type>
int	simplelist<type>::operator+=(const simplelist<type> l)
{
	int		i;
	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return 0;
}

template<class type>
simplelist<type>	&simplelist<type>::operator=(const simplelist<type> l)
{
	int		i;

	empty();	
	for(i = 0;i < l.length();i++)
	{
		append(l[i]);
	}

	return *this;
}

template<class type>
simplelist<type>	simplelist<type>::operator+(const type l) const
{
	simplelist<type>	tmp = *this;

	tmp.append(l);

	return tmp;
}

template<class type>
simplelist<type>	simplelist<type>::operator+(const simplelist<type> l) const
{
	simplelist<type>	tmp(*this);
	int		i;

	for(i = 0;i < l.length();i++)
	{
		tmp.append(l[i]);
	}

	return tmp;
}

template<class type>
int	simplelist<type>::append(const type l)
{
	lptr = (type *)realloc(lptr,(size + 1) * sizeof(type));
	if(lptr)
	{
		lptr[size] = l;
		size++;

		return 0;
	}

	size = 0;

	return -1;
}

template<class type>
int	simplelist<type>::isEmpty() const
{
	if(!lptr && size == 0) return !0;
	if((!lptr && size != 0) || (lptr && size == 0)) return -1;

	return 0;
}

template<class type>
type	&simplelist<type>::getFirst()
{
	if(isEmpty()) return errorvalue;

	return lptr[0];
}

template<class type>
type	&simplelist<type>::getLast()
{
	if(isEmpty()) return errorvalue;

	return lptr[size - 1];
}

template<class type>
type	&simplelist<type>::at(int t)
{
	if(isEmpty()) return errorvalue;

	if(t < 0 || t >= size) return errorvalue;

	return lptr[t];
}

template<class type>
const type	simplelist<type>::at(int t) const 
{
	if(isEmpty())
		return errorvalue;

	if(t < 0 || t >= size)
		return errorvalue;

	return lptr[t];
}

template<class type>
type	*simplelist<type>::atPtr(int t) const
{
	if(isEmpty()) return 0;

	if(t < 0 || t >= size) return 0;

	return &lptr[t];
}

template<class type>
type	*simplelist<type>::operator()(int t) const
{
	return atPtr(t);
}

template<class type>
type	&simplelist<type>::operator[](int t)
{
	return at(t);
}

template<class type>
const type	simplelist<type>::operator[](int t) const
{
	return at(t);
}


template<class type>
int		simplelist<type>::length() const
{
	return size;
}

#endif

