/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transform.h
*/
#ifndef __TRANSFORM_H__
#define __TRANSFORM_H__

#include "num.h"
#include <list.h>
#include "base.h"

class transform : public base
{
protected:
	Vector3		vscale,vrotate,vtranslate;
	Vector3		vascale,varotate,vatranslate;

public:
	transform(base *p = 0,const char *n="Untitled");
	transform(base *p,const char *n,Vector3&,Vector3&,Vector3&);
	transform(base *p,transform *);
	virtual	~transform();

	void			translate(Vector3 v);
	void			translate(double x,double y,double z);
	int			atranslate(param**,list<param*>*);
	int			asetTranslation(param**,list<param*>*);
	int			agetTranslation(param**,list<param*>*);
	int			agetPosition(param**,list<param*>*);

	void			rotate(Vector3 v);
	void			rotate(double x,double y,double z);
	void			rotateDeg(Vector3 v);
	void			rotateDeg(double x,double y,double z);
	int			arotate(param**,list<param*>*);
	int			asetRotation(param**,list<param*>*);
	int			agetRotation(param**,list<param*>*);
	int			agetAngle(param**,list<param*>*);

	void			scale(Vector3 v);
	void			scale(double d);
	void			scale(double x,double y,double z);
	int			ascale(param**,list<param*>*);
	int			asetScalation(param**,list<param*>*);
	int			agetScalation(param**,list<param*>*);
	int			agetSize(param**,list<param*>*);

	int			agetObjectDistance(param**,list<param*>*);

	Vector3			&getVScale();
	Vector3			&getVRotate();
	Vector3			&getVTranslate();
	void			setVScale(Vector3 &v);
	void			setVRotate(Vector3 &v);
	void			setVTranslate(Vector3 &v);

	void			transformMatrix(Matrix44 &m,int anim = 0);

	virtual int		addToParent(base*) = 0;
	virtual int		removeFromParent() { return -1; };

	virtual base		*copy(base *parent) = 0;

	virtual Matrix44	getMatrix(int anim = 0);
	virtual Matrix44	getMatrix(transform*,int anim = 0);

	virtual int		exportPOV(FILE*,int tab,int tabsize,int anim) = 0;

	virtual void		dumpNames(int tab,int tabsize) = 0;

	virtual int		save(media*,int version);
	virtual int		load(media*,int,int version);
	
	virtual Vector3		mapToGlobal(int anim = 0);
	virtual Vector3		mapToParent(transform*,int anim = 0);
	virtual Vector3		mapToGlobalAngle(int anim = 0);
	virtual Vector3		mapToParentAngle(transform*,int anim = 0);
	
 	virtual bool		acceptChild(base*) {return false;};
	virtual bool		acceptChild(body*) {return false;};
	virtual bool		acceptChild(refptr*) {return false;};
	virtual bool		acceptChild(ref*) {return false;};
	virtual bool		acceptChild(csgobj*) {return false;};
	virtual bool		acceptChild(blobobj*) {return false;};
	virtual bool		acceptChild(nonsolid*) {return false;};

 	virtual int		addChild(base*) {return -1;};
	virtual int		addChild(body*) {return -1;};
	virtual int		addChild(refptr*) {return -1;};
	virtual int		addChild(ref*) {return -1;};
	virtual int		addChild(csgobj*) {return -1;};
	virtual int		addChild(blobobj*) {return -1;};
	virtual int		addChild(nonsolid*) {return -1;};

	virtual int		removeChild(base*) {return -1;};
	virtual int		removeChild(body*) {return -1;};
	virtual int		removeChild(refptr*) {return -1;};
	virtual int		removeChild(ref*) {return -1;};
	virtual int		removeChild(csgobj*) {return -1;};
	virtual int		removeChild(blobobj*) {return -1;};
	virtual int		removeChild(nonsolid*) {return -1;};

	virtual int		hasChild(base*) {return -1;};
	virtual int		hasChild(body*) {return -1;};
	virtual int		hasChild(refptr*) {return -1;};
	virtual int		hasChild(ref*) {return -1;};
	virtual int		hasChild(csgobj*) {return -1;};
	virtual int		hasChild(blobobj*) {return -1;};
	virtual int		hasChild(nonsolid*) {return -1;};

	virtual int		moveChild(base*) {return -1;};
	virtual int		moveChild(body*) {return -1;};
	virtual int		moveChild(refptr*) {return -1;};
	virtual int		moveChild(ref*) {return -1;};
	virtual int		moveChild(csgobj*) {return -1;};
	virtual int		moveChild(blobobj*) {return -1;};
	virtual int		moveChild(nonsolid*) {return -1;};
};

#endif	
