/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** cmesh.h
*/

#ifndef __CMESH_H__
#define __CMESH_H__

#include <list.h>
#include <classes.h> 
#include <matmath.h> 

#include <objects.h> 


class graph; 
class edge;
class node;


class cmesh : public smesh
{
protected:
	graph			*gptr;

public:
	cmesh(base *p=0,char *n="Untitled",texture *t=0);
	cmesh(base *p,char *n,Vector3&,Vector3&,Vector3&);
	cmesh(base *p,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	cmesh(base *p,cmesh *mc);

	cmesh(smesh&);	// Typumwandlung

	~cmesh();

	virtual int	addChild(csgobj*);
	virtual int	addChild(blobobj*);

	int		addChild(box*);
	int		addChild(cone*);
	int		addChild(cylinder*);
	int		addChild(sphere*);
	int		addChild(text*);

	int		addSegment(int a,int b,int c)
	{
		return smesh::addSegment(a,b,c);
	}
	bool		hasSegment(int a,int b,int c)
	{
		return smesh::hasSegment(a,b,c);
	}
	
	virtual int	subdevide();
	virtual int	subdevideClever(int base,double grade);
	virtual int	simplify(double g);
	
	int		smooth();
	
	int		isClose();
	list<edge*>	getOpenPolygone(list<edge*>);
	int		closeMesh();
	int		close();

	int		isConvex();

	int		addMesh(cmesh&);
	int		addMesh(cmesh*);

	int		subtractMesh(cmesh&);
	int		subtractMesh(cmesh*);

	int		intersectMesh(cmesh&);
	int		intersectMesh(cmesh*);

	virtual int	addToParent(base *);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int,int);

	virtual int	exportPOV(FILE *,int,int,int anim = 0);
	virtual int	save(media*,int);
	virtual int	load(media*,int,int);

private:
	graph		*createGraph();
	int		createFromGraph(graph*);
	
	int		exportPOVMesh(FILE*,int,int,int);
	int		exportPOVCSG(FILE*,int,int,int);

	int		addSegment(edge *e1,edge *e2,edge *e3);
	bool		hasSegment(edge *e1,edge *e2,edge *e3);
	int		addSegment(node *n1,node *n2,node *n3);
	bool		hasSegment(node *n1,node *n2,node *n3);
	int		getNodeIndex(node *n);
};


#endif



