/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** disc.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "disc.h"

disc::disc(base *p,const char *n,double hr ) :
	nonsolid(p,n)
{
	numtype = NUM_DISC;
	hole_radius = hr;

	if(parent) addToParent(parent);
}

disc::~disc()
{
	// workaround
	removeFromParent();
}

int disc::addToParent(base *p)
{
	if (!p) return -2;
	return p->addChild(this);
}

void disc::dumpNames(int tab, int)
{
	printTab(stderr, tab);
	printf("disc: %s\n",name);
}

int	disc::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = disc\n");

	printTab(fp,tab);
	fprintf(fp,"disc\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"{<0, 0, 0>,<0, 1, 0>,\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"1, %f\n",hole_radius);

	transform::exportPOV(fp,tab,tabsize,anim);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");	

	return 0;
}

int disc::save(media *m,int ver)
{
	if(!m) return -1;
	
	switch(ver)
	{
		case 0:
		case -1:
			setMedia(m);

			writeChunk("DISC");
			writeNameChunk(name);

			saveFlags(m);

			writeDouble(hole_radius);
			anim::save(m);
			transform::save(m,ver);
			writeChunkLen();
		break;
		default:
			return -2;
	}

	return 0;
}

int	disc::load(media *m,int l,int ver)
{
	int	pos = m->tell();

	if(!m) return -1;

	switch(ver)
	{
		case 0:
		case -1:
			loadFlags(m,l);

			hole_radius = readDouble();

			anim::load(m,l - (m->tell() - pos));
			transform::load(m,l - (m->tell() - pos),ver);
		break;
		default:
			return -2;
	}

	return 0;
}



