/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** heightfield.h
*/
#ifndef __HEIGHTFIELD_H__
#define __HEIGHTFIELD_H__

#include <classes.h>

#include <misc.h>

class heightfield:public csgobj
{
protected:
	char	*filename;
	int	hierarchy;
	int	smooth;
	double	water_level;
	float	*field;
	int	field_w,field_h;	

public:
	heightfield(base *b=0,char *n="Untitled",char *fn="",int h=FALSE,int s=FALSE,double wl=0,texture *t=0);
	heightfield(base*,char*,char*,int,int,double,Vector3&,Vector3&,Vector3&);
	heightfield(base*,char*,char*,int,int,double,texture*,Vector3&,Vector3&,Vector3&);
	heightfield(base*,heightfield*);
	~heightfield();

	int		setField(float *f,int w,int h);

	void		setWaterLevel(double);
	double		getWaterLevel();
	void		setFileName(const char *);
	char		*getFileName();
	void		setSmoothness(const bool b);
	bool		getSmoothness();

	virtual int	exportPOV(FILE *,int,int,int anim = 0);
	virtual int	save(media *,int);
	virtual int	load(media *,int,int);

	virtual int	addToParent(base *o);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int, int);

	virtual int	draw(view *,Matrix44,int);
	virtual int	calculate(int);

	virtual double	volume(int anim = 0) {return 0;};
	
	int		agetHeight(param**,list<param*>*);

};

#endif
