/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** smesh.h
*/

#ifndef __SMESH_H__
#define __SMESH_H__

#include <list.h>
#include <classes.h> 
#include <matmath.h> 


class	cmesh;
class	box;
class	sphere;
class	cone;
class	cylinder;
class	torus;
class	text;

class smesh : public csgobj
{
private:
	struct dvec {Vector3 position,direction;};
	struct seg {int	pointnum[3];};

protected:
	simplelist<dvec>	vectorlist;
	simplelist<seg>		trianglelist;

public:
	smesh(base *p=0,char *n="Untitled",texture *t=0);
	smesh(base *p,char *n,Vector3&,Vector3&,Vector3&);
	smesh(base *p,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	smesh(base *p,smesh *mc);

	smesh(cmesh&);	// Typumwandlung

	~smesh();

	virtual int	addChild(csgobj*);
	virtual int	addChild(blobobj*);

	int		addChild(box*);
	int		addChild(cone*);
	int		addChild(cylinder*);
	int		addChild(sphere*);
	int		addChild(text*);

	int		addNode(double x, double y, double z,double nx = 0, double ny = 0, double nz = 0);
	int		addNode(Vector3 v,Vector3 n = Vector3(0,0,0));
	int		addSegment(int p1,int p2,int p3);

	int		getNode(int,Vector3&,Vector3&);
	Vector3		&getPoint(int);
	Vector3		&getNormal(int);
	int		getSegment(int,int&,int&,int&);

	bool		hasSegment(int,int,int);
	int		findSegment(int,int,int);
	
	int		removeSegment(int segnum);
	int		removeNode(int nodenum);

	void		empty();
	
	int		getNumNodes();
	int		getNumSegments();
	
	virtual int	simplify(double);
	virtual int	subdevide();
	virtual int	subdevideClever(int base,double grade);


	virtual int	addToParent(base *);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int,int);

	virtual int	exportPOV(FILE *,int,int,int anim = 0);
	virtual int	save(media*,int);
	virtual int	load(media*,int,int);

	virtual int	draw(view *,Matrix44,int);
	virtual int	calculate(int);
	virtual double	volume(int) 
	{ 
		return 0; 
	} 

};


#endif



