/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** view.h
*/
#ifndef __VIEW_H__
#define __VIEW_H__


#include <matmath.h>
#include <chunk.h>

#include "world.h"

#define EPSILON	1e-100

class camera;

class view : public base
{
public:
	typedef enum
	{
		PERSPECTIVE = 1,
		PARALLEL_XY,
		PARALLEL_XZ,
		PARALLEL_ZY,
	}
	PROJECTION;

protected:
//	char		*name;
	camera		*cameraptr;

	Matrix44	mview,mscreen;
	Vector3		peye;
	Vector3		vview;
	Vector3		vright;
	Vector3		vup;
	double		fov,aspect_ratio;
	int		w,h;

	int		projmode;	

	world		*worldptr;
	base		*subobject;
	char		*soname;
	
	base		*selectedptr;
	int		drawselected;
	
	bool		autodelete;

public:
	view(world *w,const char *n,bool autodelete = TRUE);
	view(world *w,view &v,bool autodelete = TRUE);
	view(world *w,view *v,bool autodelete = TRUE);

	virtual		~view();

	bool		autoDelete();
	void		setAutoDelete(bool);
		
	virtual	int	addToParent(base *p);
	virtual	int	removeFromParent();
	
	base		*copy(base*);
	
	void		dumpNames(int,int);
	
	void		take(view &v);
	void		take(view *v);

	void		setCamera(camera *c);
	camera		*getCamera();

	int		setWorld(world *wp);
	world		*getWorld();
	int		setEye(Vector3 p);
	int		setLookAt(Vector3 p);
	int		setUp(Vector3 p);
	int		setRight(Vector3 p);

	int		setFOV(double d);
	int		setAspectRatio(double d);
	int		setScreenSize(int,int);

	int		translate(Vector3);
	int		rotate(Vector3);
	int		scale(Vector3);
	
	int		project(Vector3 v,Vector2 &xy,Matrix44 m);
	int		project(Vector3 v,Vector2 &xy,Matrix44 m,int);
	int		reproject(Vector2 xy,Vector3 &v,Matrix44 m);
	int		reproject(Vector2 xy,Vector3 &v,Matrix44 m,int);


	void		setProjectionMode(int pm);
	int		projectionMode();

	void		setSelected(base *bp);
	base		*getSelected();
	void		setDrawSelected(int sel);

	virtual int	drawLine(Vector3,Vector3,Matrix44);
	virtual int	drawLine(Vector3,Vector3,Matrix44,int);
	virtual int	drawCross(Vector3,Matrix44);
	virtual int	drawCross(Vector3,Matrix44,int);
	virtual int	drawTriangle(Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawTriangle(Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawTrapezium(Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawTrapezium(Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawCircle(Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawCircle(Vector3,Vector3,Vector3,Matrix44,int);

	virtual int	drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44);
	virtual int	drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);
	virtual int	drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44);
	virtual int	drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);

	virtual int	drawBlobSphere(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawBlobSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawBlobCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44);
	virtual int	drawBlobCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);

	virtual int	drawSymbol(Vector3,const char*,Matrix44);
	virtual int	drawSymbol(Vector3,const char*,Matrix44,int);

	virtual int	drawAxis(Matrix44);
	virtual int	drawAxis(Matrix44,int);
	virtual int	drawDragvector(Matrix44,Vector3,Vector3);
	virtual int	drawDragvector(Matrix44,Vector3,Vector3,int);

	virtual void	resize();
	
	int		exportPOV(FILE*,int,int);
	int		exportPOV(FILE*,int,int,int);

	int		save(media*,int);
	int		load(media*,int,int);

	Vector3		getVView();
	Vector3		getVRight();
	Vector3		getVUp();
	Vector3		getPEye();

	int		calculate(int);
	double		volume(int);
	int		draw(view*,Matrix44,int);
	
	int		setSubObject(base*);
	
	int		getWidth();
	int		getHeight();

#if (USE_RTTI == 0)
	int		bv;
	
	int		baseview()
	{
		return bv;
	}
#endif
	
protected:

	void		createView(int);
	void		createScreen(int w,int h);
	void		calcVectors();
	void		calcVectors(int);
	
	base		*getSubObject();	
};


#endif

