/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalmap.cpp
*/
#include "normalmap.h"

#include <misc.h>

normalMap::normalMap(textureBase *p):textureBase(NORMALMAP,p)
{
	setName("Normalmap");
	setInfo("Normalmap");
	setSubItems(true);

	addAddableItem(NORMAL,false);
	addAddableItem(NORMALENTRY,true);
	addAddableItem(NORMALMAP,false);
	addAddableItem(NORMALLIST,false);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(PATTERNMODIFIER,false);

}


bool normalMap::isEqual(textureBase *tb)
{

#ifdef DEBUG
	printf("Comparing Normalmaps..\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Normalmaps..found it !\n");
#endif
	return true;
}

void normalMap::add(textureBase *tb)
{
	if (!tb) return;
	addElement(tb,NULL);
}


void normalMap::addElement(textureBase* what,textureBase *where)
{
int t;

#ifdef DEBUG
	printf("Adding Normalmap-Element (length=%d)\n",elements.length());
#endif

      	if (!what) return;
	if (canAdd(what)==false) return;
	what->setParent(this);
	what->setActive(true,NULL);
	t=what->getType();

	switch (t) {
		case NORMAL:
		{
			normalEntry *ce=new normalEntry(this);
			ce->add(what);
			elements.append(ce);
		}
		break;
		case NORMALLIST:
		{
		textureBase *tb=what->getFirstElement();
			while(tb!=NULL) {
				normalEntry *ce=new normalEntry(this);
				ce->add( (normal *)tb);
				elements.append(ce);
				tb=what->getNextElement();					
			}
		}
		break;
		default:
			textureBase::addElement(what,where);
		break;
	
	}
	sortNormalMap();
        updateInfo();
}


void normalMap::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Normalmap (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

patternmodifier *normalMap::getMapModifier()
{
	return &modifier;
}



void normalMap::clearNormalMap()
{
	textureBase::clearElements();
	updateInfo();
}

void normalMap::sortNormalMap()
{
int a,i,j;
normalEntry *ce;

#ifdef DEBUG
	printf("sorting NormalMap\n");
#endif
	a=elements.length();
	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((normalEntry*)elements[j])->getRange()>((normalEntry*)elements[j+1])->getRange() ) {
				ce=(normalEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=ce;

			}
		}
	}	
#ifdef DEBUG
	printf("NormalMap sorted\n");
#endif
	updateInfo();
}

normalMap::~normalMap()
{
}

int	normalMap::load(media *m,int l)
{
	normalEntry *ce;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	setMedia(m);

#ifdef DEBUG
	printf("loading NormalMap\n");
#endif


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"NRME",4) == 0) {
			ce=new normalEntry(this);
			ce->load(m,len);
			elements.append(ce);
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}	
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

#ifdef DEBUG
	printf("NormalMap loaded\n");
#endif
 	sortNormalMap();
	updateInfo();
	return 0;
}

int	normalMap::save(media *m)
{

int i;
	if(!m) return -1;
#ifdef DEBUG
	printf("saving NormalMap\n");
#endif
	setMedia(m);
	
	writeChunk("NRMM");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("NormalMap saved\n");
	#endif*/
	return 0;

}

int normalMap::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
int i;
	if(!fp)	return -1;

#ifdef DEBUG
	printf("exporting NormalMap (POV)\n");
#endif


	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"normal_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==NORMALENTRY)) elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);			
	}

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);	

	printTab(fp,tab);
	fprintf(fp,"}\n" );	


	#ifdef DEBUG
		printf("NormalMap exported (POV)\n");
	#endif
	return 0;
}