/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texture.cpp
*/
#include <misc.h>
#include "texture.h"

const char *TextYellowFolderPic[]={
"15 13 6 1",
"d c #000000",
"b c #ffff00",
". c None",
"# c #999999",
"a c #cccccc",
"c c #ffffff",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"##############d",
".dddddddddddddd"};

texture::texture(textureBase *p) :
	  textureBase(TEXTURE,p)
{
	setName("Material");
	setInfo( (char*)"Material");
	setSubItems(true);

	addAddableItem(PIGMENT,true);
	addAddableItem(PIGMENTLIST,true);
	addAddableItem(PIGMENTMAP,true);
	addAddableItem(NORMAL,true);
	addAddableItem(NORMALLIST,true);
	addAddableItem(NORMALMAP,true);
	addAddableItem(FINISH,true);
	addAddableItem(INTERIOR,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(IMAGEMAP,true);
	addAddableItem(COLOR,true);
	addAddableItem(IMAGEMAP,true);
	addAddableItem(COLORMAP,true);
	addAddableItem(COLORLIST,true);
	addAddableItem(BUMPMAP,true);
	addAddableItem(DENSITY,true);
	addAddableItem(SLOPEMAP,true);
	addAddableItem(SURFACE,true);		
	addAddableItem(SURFACEMAP,true);
	addAddableItem(SURFACELIST,true);


}

const char **texture::getXPM()
{
	return TextYellowFolderPic;
}

void	texture::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

        switch(tb->getType() ) {
		case SURFACE:
			tb->setActive(a,NULL);
		break;
		case INTERIOR:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==INTERIOR) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a,NULL);
		break;
		case TRANSFORMATIONS:
			for (i=0;i<elements.length();i++) {
				if (elements[i]->getType()==TRANSFORMATIONS) {
					elements[i]->setActive(false,NULL);
				}
			}
			tb->setActive(a,NULL);
		break;
		default:
		break;
	}
}

void texture::addElement(textureBase* what,textureBase* where)
{
	if (!what) return;
	if (canAdd(what)==false) return;
	what->setParent(this);	
	setActive(true,what);
	switch (what->getType()) {
		case COLOR:
		case COLORLIST:
		case COLORMAP:
		case IMAGEMAP:
		case BUMPMAP:
		case SLOPEMAP:
		case NORMALMAP:
		case NORMALLIST:
		case SURFACEMAP:
		case SURFACELIST:
		case PIGMENT:
		case PIGMENTLIST:
		case PIGMENTMAP:
		case NORMAL:
		case FINISH:
		{
                        surface *su=(surface *)getElementByType(SURFACE);
			if (!su) {
				su=new surface(this);
				addElement(su,NULL);
			}
			what->setParent(su);
			su->add(what);
		}
		break;	
		case DENSITY:
		{
			interior *in=(interior *)getElementByType(INTERIOR);
			if (!in) {
				in=new interior(this);
				addElement(in,NULL);
			}
			what->setParent(in);
			in->add(what);

		}
		break;
		default:
			textureBase::addElement(what,where);
		break;
	}
}

void texture::add(textureBase *tb)
{
	addElement(tb,NULL);
}

bool texture::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Textures...\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Textures..found it !\n");
#endif
	return true;
}


texture::~texture()
{
}

int	texture::save(media *m)
{
int i;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving Texture\n");
	#endif
	setMedia(m);

	writeChunk("MATR");

	textureBase::save(m);

	for (i=0;i<elements.length();i++) elements[i]->save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("Texture saved\n");
	#endif

	return 0;
}

int	texture::load(media *m,int l)
{
	surface		*su=NULL;
	interior 	*in=NULL;
	Transformations *tr=NULL;

	char	chunk[4];
	int	len,pos = m->tell();
	bool	read=false;

	if(!m)
		return -1;
	#ifdef DEBUG
		printf("loading Material\n");
	#endif

	setMedia(m);
	
	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"TXTR",4) == 0) {
			elements.append ( (su=new surface(this)) );
			su->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			elements.append ( (tr=new Transformations(this)) );
			tr->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"INTE",4) == 0) {
			elements.append ( (in=new interior(this)) );
			in->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("MAterial loaded\n");
	#endif

	return 0;
}

int	texture::savePtr(media *m)
{
	if(!m) return -1;

	setMedia(m);
	writeChunk("TXTP");

	writeName(getPath());

	writeChunkLen();

	return 0;
}

int	texture::loadPtr(media *m,int)
{
char *dummy;
	if(!m) return -1;

	setMedia(m);

	dummy = readName();

	return 0;
}

int	texture::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	return exportPOV(fp,tab,tabsize,anim,false);
}

int	texture::exportPOV(FILE *fp,int tab,int tabsize,int anim,bool as_macro)
{
	int i,j;
	surface  *su=NULL;
	interior *in=NULL;
	Transformations *tr=NULL;
	int layermax=0;	
	int layermin=0;	

	#ifdef DEBUG
		printf("exporting Material (POV)\n");
	#endif	
	if (as_macro==false) {
		printTab(fp,tab);

		fprintf(fp,"// Objecttype = Material\n");
		printTab(fp,tab);

		fprintf(fp,"material { //name=%s , path=%s\n",name,getPath());	
	} else {
		printTab(fp,tab);
		fprintf(fp,"#declare %s = material { //name=%s \n",getPath(),name );	
		tab=tab+tabsize;
	}

	// (gelayerte) Surface exportieren

	for (i=0;i<elements.length();i++) if ((elements[i]->getType()==SURFACE)&&(elements[i]->active()==true)) {
			su=(surface *)elements[i];	
			layermax=MAX(layermax,su->getLayer());
			layermin=MIN(layermin,su->getLayer());			
	}

	for (j=layermin;j<=layermax;j++) {
		for (i=0;i<elements.length();i++) {
			if ((elements[i]->getType()==SURFACE)&&(elements[i]->active()==true)) {
				su=(surface *)elements[i];	
				if (su->getLayer()==j) su->exportPOV(fp,tab+tabsize,tabsize,anim,false);
			}
		}
	}
	
	//----------------------------------------------------------------------
	for (i=0;i<elements.length();i++) {
		if ((elements[i]->getType()==INTERIOR)&&(elements[i]->active()==true)) in=(interior *)elements[i];	
	}
	for (i=0;i<elements.length();i++) {
		if ((elements[i]->getType()==TRANSFORMATIONS)&&(elements[i]->active()==true)) tr=(Transformations*)elements[i];	
	}

	
	if (in)	in->exportPOV(fp,tab+tabsize,tabsize,anim,false);
	if (tr)	tr->exportPOV(fp,tab+tabsize,tabsize,anim,false);

	printTab(fp,tab);
	fprintf(fp,"}\n");	
	
	#ifdef DEBUG
		printf("Material exported (POV)\n");
	#endif

	return 0;
}
