/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturemap.h
*/

#ifndef __TEXTUREMAP_H__
#define __TEXTUREMAP_H__

#include <list.h>
#include "texture.h"
#include <chunk.h>

class texturemap : public virtual chunk
{
protected:

	char			*_name;
	list<texture*>		texturelist;
	list<texturemap*>	texturemaplist;

public:

	texturemap(char *n);
	~texturemap();

	char		*name();
	texture		*findTexture(char*);
	char		*texturePath(char*);

	void		addTexture(texture*);
	void		addTexturemap(texturemap*);

	void		removeTexture(texture*);
	void		removeTexturemap(texturemap*);

	int		getNumTextures();
	texture		*getTexture(int);
	texture		*getFirstTexture();
	texture		*getNextTexture();

	int		getNumTextureMaps();
	texturemap	*getTextureMap(int);
	texturemap	*getFirstTexturemap();
	texturemap	*getNextTexturemap();

	int		save(media*);
	int		load(media*,int);
};

#endif



