/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** df3.cpp
*/
#include "df3.h"
#include "df3.moc"

#include <stdio.h>
#include <kapp.h>

DF3Dialog::DF3Dialog(base *bp,QWidget *pw) :
	QDialog(pw,"DF3",TRUE)
{
	parent = bp;
	
	gfw = new GetFileWidget(this,i18n("DF3-file:"));
	
	ok = new QPushButton(this);
	ok->setText(i18n("OK"));
	connect(ok,SIGNAL(clicked()),SLOT(okPressed()));
	
	cancel = new QPushButton(this);
	cancel->setText(i18n("Cancel"));
 	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	
 	resize(400,75);
 	
	layout();
}

DF3Dialog::~DF3Dialog()
{
}

void	DF3Dialog::layout()
{
	int	x,y,w,h,w2;
	
	setCaption(i18n("DF3"));
	
	x = 5;
	y = 5;
        w = width() - 10;

        gfw->setLabelWidth(w2);
        gfw->setGeometry(x,y,w,h);


	w2 = MAX(ok->sizeHint().width(),cancel->sizeHint().width());

        x = width() - 10 - 2 * w2;
        y = height() - 30;
        w = w2;
        h = 25;

        ok->setGeometry(x,y,w,h);

        x += w + 5;
        cancel->setGeometry(x,y,w,h);
}


void	DF3Dialog::paintEvent(QPaintEvent*)
{
	layout();
}

void	DF3Dialog::okPressed()
{
	QString		fn;
	int		w,h,d,i;
	unsigned char	*f;
	FILE		*fp;
	
	fn = gfw->getFilename();
	fp = fopen(fn,"r");
	if(fp)
	{
		w = (fgetc(fp) << 8) + fgetc(fp);
		h = (fgetc(fp) << 8) + fgetc(fp);
		d = (fgetc(fp) << 8) + fgetc(fp);
		f = (unsigned char*)malloc(w * h * d);
		if(f)
		{
			for(i = 0;i < w * h * d;i++)
				f[i] = fgetc(fp);
				
			createModelFromDF3(parent,w,h,d,f,true,true);
		}
		fclose(fp);
	}
	
	accept();
}

csg	*DF3Dialog::createModelFromDF3(base *p,int w,int h,int d,unsigned char *field,bool cframe,bool cgrid)
{
	csg		*model,*density,*frame,*grid;
	sphere		*sp;
	cylinder	*cy;

	double		dens,r;

	int		x,y,z;
	double		dx,dy,dz;
	double		xa,xb,ya,yb,za,zb;

        char		str[40];

	if(p == 0 || field == 0)
		return 0;

	printf("%i,%i,%i\n",w,h,d);
	
	if((model = new csg(p,"DF3Model")))
	{
		if((density = new csg(model,"Density")))
		{
			for(x = 0;x < w;x++)
			{
				for(y = 0;y < h;y++)
				{
					for(z = 0;z < d;z++)
					{
						sprintf(str,"Density%6i",x + y * w + z * w * h);
						if((sp = new sphere(density,str)))
						{
							dens = (double)(field[x + y * w + z * w * h]) / 255.0;
							r = (dens * 0.99 + 0.01) / 2;
				
							printf("%g -> %g\n",dens,r);
							
							dx = 0.5 / (double)w * (1 + 2 * (double)x);
							dy = 0.5 / (double)h * (1 + 2 * (double)y);
							dz = 0.5 / (double)d * (1 + 2 * (double)z);
				
							sp->translate(dx,dy,dz);
	
							dx = r / (double)w;
							dy = r / (double)h;
							dz = r / (double)d;
	
							printf("%g -> %g %g %g\n",r,dx,dy,dz);
							
							sp->scale(dx,dy,dz);
						}
						printf("%i of %i\n",x * h * d + y * d + z,w * h * d);
					}
				}
			}
		}
		if(cframe)
		{
			if((frame = new csg(model,"Frame")))
			{
				xa = 0.5 / (double)w;
				xb = 1 - 0.5 / (double)w;
				ya = 0.5 / (double)h;
				yb = 1 - 0.5 / (double)h;
				za = 0.5 / (double)d;
				zb = 1 - 0.5 / (double)d;
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,0.01 / (double)h,0.99 / (double)d);
					cy->translate(xa,ya,0.5);
					cy->rotateDeg(0,0,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.99 / (double)w,0.01 / (double)h,0.01 / (double)d);
					cy->translate(0.5,ya,zb);
					cy->rotateDeg(0,90,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,0.01 / (double)h,0.99 / (double)d);
					cy->translate(xb,ya,0.5);
					cy->rotateDeg(0,0,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.99 / (double)w,0.01 / (double)h,0.01 / (double)d);
					cy->translate(0.5,ya,za);
					cy->rotateDeg(0,90,0);
				}

				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,0.01 / (double)h,0.99 / (double)d);
					cy->translate(xa,yb,0.5);
					cy->rotateDeg(0,0,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.99 / (double)w,0.01 / (double)h,0.01 / (double)d);
					cy->translate(0.5,yb,zb);
					cy->rotateDeg(0,90,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,0.01 / (double)h,0.99 / (double)d);
					cy->translate(xb,yb,0.5);
					cy->rotateDeg(0,0,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.99 / (double)w,0.01 / (double)h,0.01 / (double)d);
					cy->translate(0.5,yb,za);
					cy->rotateDeg(0,90,0);
				}

				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,1 - 0.01 / (double)h,0.01 / (double)d);
					cy->translate(xa,0.5,za);
					cy->rotateDeg(0,90,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,1 - 0.01 / (double)h,0.01 / (double)d);
					cy->translate(xa,0.5,zb);
					cy->rotateDeg(0,90,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,1 - 0.01 / (double)h,0.01 / (double)d);
					cy->translate(xb,0.5,zb);
					cy->rotateDeg(0,90,0);
				}
				if((cy = new cylinder(frame,"Frame")))
				{
					cy->scale(0.01 / (double)w,1 - 0.01 / (double)h,0.01 / (double)d);
					cy->translate(xb,0.5,za);
					cy->rotateDeg(0,90,0);
				}
			}
		}
	}


	return model;
}



