/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** df3.h
*/
#ifndef __DF3_H__
#define __DF3_H__

#include <objects.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include "../widgets/getfilewidget.h"

class DF3Dialog : public QDialog
{
Q_OBJECT
protected:
        base		*parent;

        GetFileWidget	*gfw;

	QPushButton	*ok,*cancel;
	
public:
	DF3Dialog(base *pbase=0,QWidget* pw=0);
	~DF3Dialog();

	csg		*createModelFromDF3(base *p,int w,int h,int d,unsigned char *field,bool cframe,bool cgrid);
	
private:
	void		layout();
	
private slots:
	void		paintEvent(QPaintEvent*);
	void		okPressed();
};


#endif


