/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** recursivtree.cpp
*/
#include "forestgen.h"
#include "forestgen.moc"

#include "../misc/preferences.h"

#include <stdio.h>
#include <kapp.h>
#include <qimage.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlistview.h>

#include "../misc/preferences.h"

ForestGeneratorDialog::ForestGeneratorDialog(QPixmap **pma,obj *objp,QWidget *pw) :
	QDialog(pw,"Recursive",TRUE)
{
	pmap = pma;
	objptr = objp;
	
	lex = new QLabel(this);
	lex->setText(i18n("Example:"));
	
	cex = new QComboBox(true,this);
	initExamples();
	
	del = new QPushButton(this);
	del->setText(i18n("Delete"));
	
	save = new QPushButton(this);
	save->setText(i18n("Save"));
	
	lfn = new QLabel(this);
	lfn->setText(i18n("Function:"));
	
	efn = new QLineEdit(this);
	efn->setText("f()");
	
	ldepth = new QLabel(this);
	ldepth->setText(i18n("Number of plants:"));
	
	edepth = new QLineEdit(this);
	edepth->setText("6");
	
	lname = new QLabel(this);
	lname->setText(i18n("Name:"));
	
	ename = new QLineEdit(this);
	ename->setText("Tree");
	ename->setEnabled(false);
	
	tlol = new QListView(this);
	tlol->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
        tlol->setLineWidth(2);
        tlol->setMidLineWidth(2);
	tlol->setAllColumnsShowFocus(true);
	tlol->addColumn(i18n("Index"),40);
	tlol->addColumn("",26);
	tlol->addColumn(i18n("Objectname"));
	tlol->setColumnWidthMode(2,QListView::Maximum);
	tlol->setSorting(0);
		
	ok = new QPushButton(this);
	ok->setText(i18n("OK"));
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	
	cancel = new QPushButton(this);
	cancel->setText(i18n("Cancel"));
 	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	
 	resize(500,270);
 	
	layout();
	
	connect(cex,SIGNAL(activated(int)),this,SLOT(selectedExample(int)));
	connect(save,SIGNAL(clicked()),this,SLOT(savedExample()));
	connect(del,SIGNAL(clicked()),this,SLOT(deletedExample()));
	
	setObject();
}

ForestGeneratorDialog::~ForestGeneratorDialog()
{
}

void	ForestGeneratorDialog::createList()
{
        tlol->clear();

	if(!objptr)
		return;
		
	world		*worldptr;
	base		**children,*baseptr;
	QListViewItem	*li;
	QString		indexstr;
	int		i;
		
	baseptr = objptr->getRoot();
	
	if(!baseptr || baseptr->getType() != NUM_WORLD)
		return;
		
	worldptr = (world*)baseptr;
	
	
	worldptr->getChildren(&children);
	if(children == 0)
		return;
	for(i = 0;children[i] != 0;i++)
	{
		if(children[i] == objptr || children[i]->getType() != NUM_REF)
			continue;
			
		indexstr.sprintf("%i",i);
		
		li = new QListViewItem(tlol);
		li->setText(0,indexstr);
		li->setPixmap(1,*pmap[children[i]->getType()]);
		li->setText(2,children[i]->getName());
	}
	free(children);
}

void	ForestGeneratorDialog::initExamples()
{
/*
	Preferences	prefs;
	int		i;
	QString		ss;
	
	
	ss = cex->currentText();
	cex->clear();
	for(i = 0;i < prefs.getForestGeneratorNumEntries();i++)
	{
		cex->insertItem(prefs.getForestGeneratorLabel(i));
	}
	if(ss != "")
	{
		for(i = 0;i < cex->count();i++)
		{
			if(cex->text(i) == ss)
			{
				cex->setCurrentItem(i);
				break;
			}
		}
	}
*/
}

void	ForestGeneratorDialog::selectedExample(int n)
{
/*
	QString		str;
	Preferences	prefs;
	
	str = prefs.getForestGeneratorFunction(n);
	efn->setText(str);
*/
}

void	ForestGeneratorDialog::savedExample()
{
/*
	QString		label,fn;
	Preferences	prefs;
	
	label = cex->currentText();
	fn = efn->text();
	
	prefs.setForestGenerator(label,fn);
	
	prefs.save();
	
	initExamples();
*/
}

void	ForestGeneratorDialog::deletedExample()
{
/*
	QString		label;
	Preferences	prefs;
	
	label = cex->currentText();
	
	prefs.deleteForestGenerator(label);
	
	prefs.save();
	
	initExamples();
*/
}

void	ForestGeneratorDialog::layout()
{
	int	x,y,w,h,w2,w3,w4;
	
	setCaption(i18n("Forest Generator"));
	
	w2 = MAX(lfn->sizeHint().width(),ldepth->sizeHint().width());
	w2 = MAX(w2,lname->sizeHint().width());
	w2 = MAX(w2,lex->sizeHint().width());
	
	w3 = width() - 15 - w2;
	w4 = MAX(del->sizeHint().width(),save->sizeHint().width());
	 	
	x = 5;
	y = 5;
	w = w2;
	h = 25;
	
	lex->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w3 - w4 * 2 - 10;
	
	cex->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w4;
	
	del->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w4;
	
	save->setGeometry(x,y,w,h);
	
	x = 5;
	y += h + 5;
	w = w2;
	
	lfn->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w3;
	
	efn->setGeometry(x,y,w,h);

 	x = 5;
        y += h + 5;
        w = w2;

        ldepth->setGeometry(x,y,w,h);

        x += w + 5;
        w = 80;

        edepth->setGeometry(x,y,w,h);

 	x = 5;
        y += h + 5;
        w = w2;

        lname->setGeometry(x,y,w,h);

        x += w + 5;
        w = w3;

        ename->setGeometry(x,y,w,h);

	x = 5;
        y += h + 5;
        w = width() - 10;
        h = height() - y - 10 - 30;

        tlol->setGeometry(x,y,w,h);

	w2 = MAX(ok->sizeHint().width(),cancel->sizeHint().width());

        x = width() - 10 - 2 * w2;
        y = height() - 30;
        w = w2;
        h = 25;

        ok->setGeometry(x,y,w,h);

        x += w + 5;
        cancel->setGeometry(x,y,w,h);
}

void	ForestGeneratorDialog::getObject()
{
	base	**bp;
	int	i;
	
	if(objptr)
	{
		// save extradata to the mesh
		QString		qstr;
		Preferences	prefs;
			
		fn = efn->text();
       		if(objptr->setData("Forest","fn",fn) >= 0)
       			printf("xtradata fn ok!\n");
       			
      		qstr = edepth->text();
       		d = qstr.toInt();
       		if(objptr->setData("Forest","number",d) >= 0)
			printf("xtradata depth ok!\n");
			
      		name = ename->text();
		
		// now do something with the obj
		//op->clear();
		objptr->getChildren(&bp);
		for(i = 0;bp[i] != 0;i++)
			delete bp[i];
		delete bp;
		
		createObject();
	}
}

void	ForestGeneratorDialog::setObject()
{
	if(objptr)
	{
		if(objptr->hasDataCollection("Forest") >= 0)
		{
			const char	*txt;
			
			// Fill the dialog
			if(objptr->getData("Forest","fn",txt) >= 0)
			{
				fn = txt;
				efn->setText(fn);
			}
			if(objptr->getData("Forest","number",d) >= 0)
			{
				QString		qstr;
				
				qstr.setNum(d);
				edepth->setText(qstr);
			}
			ename->setText(objptr->getName());
		}
		createList();
	}
}

void	ForestGeneratorDialog::paintEvent(QPaintEvent*)
{
	layout();
}

int	ForestGeneratorDialog::parseObjects(const char *formatedin,obj *object,paralist_t *plist)
{
	char		**terms;
	char		*formated;
	char		*term;
	char		*func,*subterm;
	int		t,i,number;
	ntuple_t	*r = 0;
	char		name[40];
	paralist_t	usrplist = {0,0};
	QString		str;
	world		*worldptr;
	base		**children,*baseptr;
		
	baseptr = objptr->getRoot();
	
	if(!baseptr || baseptr->getType() != NUM_WORLD)
		return -1;
		
	worldptr = (world*)baseptr;
	
	
	worldptr->getChildren(&children);
	if(children == 0)
		return -2;
	for(i = 0;children[i] != 0;i++)
	

	
	copy_paralist(plist,&usrplist);

	
	number = atoi(edepth->text());
	
	for(i = 0;i < number;i++)
	{		
		str.sprintf("%i %s %i ",i + 1,i18n("of"),number);
		str += i18n("objects created");
		emit report(str);

		sprintf(name,"%s.%i",object->getName(),i);

		formated = strdup(formatedin);
		terms = get_simple_terms(formated);
		term = terms[0];
		t = 1;

		while(term)
		{
			func = get_function_name(term);
			subterm = get_subterm();
			if(func)
			{
				if(strcmp(func,"set") == 0)
				{
					char		**subterms;

					subterms = get_simple_terms(subterm);
					r = eval_term(subterms[1],&usrplist);
					if(r && r->tuple) set_param(&usrplist,subterms[0],r->tuple[0]);
					free(subterms);
				}
				else if(strcmp(func,"object") == 0)
				{
       					Vector3		vs(1,1,1);
       					Vector3		vr;
       					Vector3		vt;
      					int		objid = -1,i,j;
      					refptr		*rp;

					r = eval_term(subterm,&usrplist);
					if(r && r->ntuple >= 1)
					{
						objid = (int)r->tuple[0];
					}
					
					if(objid >= 0 && objid < worldptr->numChildren())
					{
						
						if(r && r->ntuple >= 4)
						{
							vs = Vector3(r->tuple[1],r->tuple[2],r->tuple[3]);
						}
						if(r && r->ntuple >= 7)
						{
							vr = Vector3(r->tuple[4],r->tuple[5],r->tuple[6]);
						}
						if(r && r->ntuple >= 10)
						{
							vt = Vector3(r->tuple[7],r->tuple[8],r->tuple[9]);
						}
					
						for(i = 0,j = 0;j != objid;i++)
						{
							if(children[i]->getType() == NUM_REF)
							{
								j++;
							}
						}
						if(children[i]->getType() == NUM_REF)
						{
							rp = new refptr(objptr,name);
							rp->addChild((ref*)children[i]);
							rp->scale(vs);
							rp->rotate(vr);
							rp->translate(vt);
						}
					}
				}
						
				if(r)
				{
					if(r->tuple)
						free(r->tuple);
					free(r);
					r = 0;
				}
			}
			term = terms[t];
			t++;
		}
		free(terms);
		free(formated);
	}
	
	kill_paralist(&usrplist);

	return 0;
}


int	ForestGeneratorDialog::createObject()
{
	QString		kochterm;
	paralist_t	plist = {0,0};


	kochterm = "(" + fn + ")";

	set_param(&plist,"PI",PI);
	set_param(&plist,"ELSE",1);

	numobj = objcounter;
	objcounter = 0;
	
	if(objptr)
	{
		char	*unformated,*formated;
		
		unformated = strdup(kochterm);
		formated = format_term(unformated);

		parseObjects(kochterm,objptr,&plist);
	
		free(unformated);
	}

	kill_paralist(&plist);
	
	return 0;
}

