/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** finishdialog.cpp
*/
#include "finishdialog.h"
#include "finishdialog.moc"

#include <kapp.h>
#include <qtooltip.h>

FinishWidget::FinishWidget(QWidget *parent,finish *f) :
	TextureWidgetBase(parent,"FinishWidget")
{
color *col;

	fi=f;

	tbasew=new TextureBaseWidget(this,fi );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	tab=new TabWidget(this,(const char*)"",0);

	page1=new QWidget(this);
	page2=new QWidget(this);
	page3=new QWidget(this);

	col=fi->getAmbient();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	ambient=new KColorButton(qc,page1);
        ambientlabel=new QLabel(i18n("Ambient:"),page1);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(ambient,i18n("Light in shadowed areas") );
#endif
	connect(ambient,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

	diffuse=new SpinBox(page1,i18n("Diffuse:"),fi->getDiffuse() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(diffuse,i18n("The light, wich comes from direct ilumination,\n0.4 means, that 40% of the ssen light comes from direct illumination from light sources") );
#endif
	connect(diffuse,SIGNAL(changed()),this,SIGNAL(valueChanged()) );


	brilliance=new SpinBox(page1,i18n("Brilliance:"),fi->getBrilliance() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(brilliance,i18n("By increasing this value, the objects appear more metallic") );
#endif
	connect(brilliance,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	phong=new SpinBox(page2,i18n("Phong:"),fi->getPhong() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(phong,i18n("The highlight\n1 causes complete saturation to the light source's color at the brightest area\n0 means no highlight") );
#endif
	connect(phong,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	phongsize=new SpinBox(page2,i18n("Phongsize:"),fi->getPhongSize() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(phongsize,i18n("The size of the highlight") );
#endif
	connect(phongsize,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	specular=new SpinBox(page2,i18n("Specular:"),fi->getSpecular() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(specular,i18n("See the phong-tip, if you use this value, an other algorhythm is used") );
#endif
	connect(specular,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	roughness=new SpinBox(page2,i18n("Roughness:"),fi->getRoughness() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(roughness,i18n("") );
#endif
	connect(roughness,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	metall=new QCheckBox(i18n("Metallic"),page2);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(metall,i18n("Simulate a metallic surface") );
#endif
	metall->setChecked(fi->getMetallic());
	connect(metall,SIGNAL(pressed()),this,SIGNAL(valueChanged()) );

	reflection=new SpinBox(page3,i18n("Reflection:"),fi->getReflection() );		
#if (USE_QTOOLTIP == 1)
	QToolTip::add(reflection,i18n("How many light is reflected") );
#endif
	connect(reflection,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	iridlabel=new QLabel(i18n("Irid:"),page3);

	iridturb=new SpinBox(page3,i18n("Turbulence:"),fi->getIridTurbulence() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(iridturb,i18n("Simulate a small slick of your object(Newtons film interference)") );
#endif
	connect(iridturb,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	iridthick=new SpinBox(page3,i18n("Thickness:"),fi->getIridThickness() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(iridthick,i18n("The Thickness of the film (see Turbulence-Tip)") );
#endif
	connect(iridthick,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	iridamount=new SpinBox(page3,i18n("Amount:"),fi->getIridAmount() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(iridamount,i18n("This is the contribution of the iridescence effect to the overall surface color.\nIf the surface is coming too white, lower this value") );
#endif
	connect(iridamount,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	tab->addWidget(page1,0,(char*)i18n("Ambient"));
	tab->addWidget(page2,1,(char*)i18n("Highlights"));
	tab->addWidget(page3,2,(char*)i18n("Reflections"));
	tab->select(0);

	paintEvent(NULL);

}

FinishWidget::~FinishWidget()
{
	if (tbasew) delete tbasew;
}


void FinishWidget::getValue()
{
color *col = new color(NULL);

	col->setRed( (double)  (ambient->color().red()/255.0)   );
	col->setGreen( (double)(ambient->color().green()/255.0) );
	col->setBlue( (double) (ambient->color().blue()/255.0)  );

	fi->setAmbient(col);	
	fi->setBrilliance(brilliance->getValue() );
	fi->setDiffuse(diffuse->getValue() );

	fi->setPhong(phong->getValue() );
	fi->setPhongSize(phongsize->getValue() );
	fi->setSpecular(specular->getValue() );
	fi->setRoughness(roughness->getValue() );
	fi->setMetallic(metall->isChecked());

	fi->setReflection(reflection->getValue() );
	fi->setIridTurbulence(iridturb->getValue() );
	fi->setIridThickness(iridthick->getValue() );
	fi->setIridAmount(iridamount->getValue() );
	
	tbasew->getTextureBase();	
}

QSize FinishWidget::sizeHint() const
{
	return qs;
}

void FinishWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,wt=0,ht=0;

	tbasew->setGeometry(10,10,w,h);
	y=15+h;
	w+=10;
	h+=10;

	//page1
	{
        int w1,h1,h2;
	
		w1=ambientlabel->sizeHint().width();
		h1=ambientlabel->sizeHint().height();

		ambientlabel->setGeometry(10,10+h1/2,w1,h1);
		ambient->setGeometry(15+w1,10,2*h1,2*h1);

		w=MAX(w,2*h1+15+w1);	
		h+=10+2*h1;

		diffuse->layout(diffuse,brilliance);
		h2=diffuse->sizeHint().height();
		w1=diffuse->sizeHint().width();

		diffuse->setGeometry(3*h1+15,30+h1,w1,h2);
		w1=brilliance->sizeHint().width();
		brilliance->setGeometry(3*h1+15,35+h1+h2,w1,h2);

		w=MAX(w,2*h1+15+w1);
		h+=35+h1+h2*2;
	}

	//page2
        {
	int w1,h1;

		phong->layout(phong,phongsize,specular,roughness);

		w1=phong->sizeHint().width();
		h1=phong->sizeHint().height();

		phong->setGeometry(10,10,w1,h1);
		w1=phongsize->sizeHint().width();
		phongsize->setGeometry(10,10+h1+5,w1,h1);

		w=MAX(w,10+w1);

		w1=specular->sizeHint().width();
		specular->setGeometry(10,30+2*h1+10,w1,h1);	
		w1=roughness->sizeHint().width();
		roughness->setGeometry(10,30+3*h1+15,w1,h1);	
		w1=metall->sizeHint().width();
		metall->setGeometry(10,40+4*h1+20,w1,h1);	

		w=MAX(w,10+w1);
		h=MAX(h,40+3*h1+20+h1);
	}

	//page3
	{	
	int w1,h1;

		reflection->layout(reflection,iridturb,iridthick,iridamount);

		w1=reflection->sizeHint().width();
		h1=reflection->sizeHint().height();
	        reflection->setGeometry(10,10,w1,h1);
	
		w1=iridlabel->sizeHint().width();
		iridlabel->setGeometry(10,10+h1+5,w1,h1);
		w1=iridturb->sizeHint().width();
		iridturb->setGeometry(30,15+2*h1,w1,h1);	
		w1=iridthick->sizeHint().width();
		iridthick->setGeometry(30,20+3*h1,w1,h1);	
		w1=iridamount->sizeHint().width();
		iridamount->setGeometry(30,25+4*h1,w1,h1);	
	
		w=MAX(w,30+w1);
		h=MAX(h,25+4*h1+h1);
	}

	tab->setSize(w,h);	
	wt=tab->sizeHint().width();
	ht=tab->sizeHint().height();

	tab->setGeometry(10,y,wt,ht);
	
	w=MAX(10+wt,w);
	h=MAX(h,y+ht);

	qs.setWidth(w+5);
	qs.setHeight(h+5);
	if (qp)QWidget::paintEvent(qp);
}



//----------------------------------------------------------

FinishDialog::FinishDialog(QWidget *parent,finish *f) :
	QDialog(parent,"FinishDialog",true)
{
	setCaption(i18n("Finish"));
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new FinishWidget(this,f);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}


void FinishDialog::okayPressed()
{  	
	pw->getValue();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void FinishDialog::cancelPressed()
{
	QDialog::done(0);
}

FinishDialog::~FinishDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}

void FinishDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);

	QDialog::paintEvent(qp);
}

