/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** imagemapdialog.cpp
*/
#include "imagemapdialog.h"
#include "imagemapdialog.moc"

#include <kapp.h>
#include <qtooltip.h>
#include <qframe.h>

ImageMapWidget::ImageMapWidget(QWidget *parent,imageMap *i) :
	TextureWidgetBase(parent,"ImageMapDialog")
{
	im=i;
	bmm=im->getModifier();	

	imgDat=new Image(this,true);	
	if (im->getImageMapFilename()!=NULL) imgDat->load(im->getImageMapFilename());

	tbasew=new TextureBaseWidget(this,im);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	filewidget=new GetFileWidget(this,i18n("File:"),im->getImageMapFilename(),1);
	connect(filewidget,SIGNAL(changed()),this,SLOT(newImage()) );

	filter=new SpinBox(this,i18n("Filter:") ,im->getImageMapFilterValue() );
	connect(filter,SIGNAL(changed()),this,SIGNAL(valueChanged()) );
	transmit=new SpinBox(this,i18n("Transmit:") ,im->getImageMapTransmitValue() );
	connect(transmit,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	mapping=new QComboBox(this);
	mapping->insertItem(i18n("planar") );
	mapping->insertItem(i18n("spherical") );
	mapping->insertItem(i18n("(reserved#1)") );
	mapping->insertItem(i18n("(reserved#2)") );
	mapping->insertItem(i18n("donut/torus") );
	mapping->setCurrentItem(bmm->getMapType() );	
	connect(mapping,SIGNAL(highlighted(int)),this,SIGNAL(valueChanged()) );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(mapping,i18n("The mapping of the imagefile around your object") );
#endif

	maplabel=new QLabel(i18n("Mapping:"),this);

	once=new QCheckBox(i18n("Once"),this);
	connect(once,SIGNAL(pressed()),this,SIGNAL(valueChanged()) );	
#if (USE_QTOOLTIP == 1)
	QToolTip::add(once,i18n("Should the image only mapped once ?") );
#endif

	if (bmm->getOnce()==1) once->setChecked(true);
	else once->setChecked(false);

	interpolate=new QComboBox(this);
	interpolate->insertItem(i18n("none") );
	interpolate->insertItem(i18n("bilinear") );
	interpolate->insertItem(i18n("normalized") );
	connect(interpolate,SIGNAL(highlighted(int)),this,SIGNAL(valueChanged()) );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(interpolate,i18n("Interpolation of the image") );
#endif

	switch(bmm->getInterpolate()) {
		case 0:interpolate->setCurrentItem(0);
		break;
		case 2:interpolate->setCurrentItem(1);
		break;
		case 4:interpolate->setCurrentItem(2);
		break;
	}
	
	interpolatelabel=new QLabel(i18n("Interpolation:"),this);
	paintEvent(NULL);
}

Image 	*ImageMapWidget::getImage()
{
	return imgDat;
}

void	ImageMapWidget::setImage(char *a, int l)
{
	imgDat->setImage(a,l);
	emit valueChanged();
	paintEvent(NULL);	
}

void ImageMapWidget::newImage()
{
QString name=filewidget->getFilename(),tmp;	
	imgDat->load(name);
	emit valueChanged();
	paintEvent(NULL);

}


ImageMapWidget::~ImageMapWidget()
{
	if (imgDat) delete imgDat;
	if (filter) delete filter;
	if (transmit) delete transmit;
	if (filewidget) delete filewidget;
	if (mapping) delete mapping;
	if (maplabel) delete maplabel;
	if (once) delete once;
	if (interpolate) delete interpolate;
	if (interpolatelabel) delete interpolatelabel;
	if (tbasew) delete tbasew;
}

void ImageMapWidget::getValue()
{
	im->setImageMapFilterValue(filter->getValue());
	im->setImageMapTransmitValue(transmit->getValue());
	im->setImageMapFilename( (const char *)(filewidget->getFilename()) );
	im->setImageMapFiletype( (const char *)(filewidget->getImageType()) );

	bmm->setMapType(mapping->currentItem());
	if (once->isChecked()) bmm->setOnce();
	else bmm->unSetOnce();
	switch(interpolate->currentItem() ) {
		case 0: bmm->setInterpolate(0);
		break;
		case 1:bmm->setInterpolate(2);
		break;
		case 2:bmm->setInterpolate(4);
		break;
	}
	tbasew->getTextureBase();
}

QSize ImageMapWidget::sizeHint() const
{	
	return qs;
}

void ImageMapWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,h2=0,w2=0,w3=0,tab;
	
	tbasew->setGeometry(10,10,w,h);
	y+=h+15;

	w=imgDat->sizeHint().width();
	h=imgDat->sizeHint().height();

	imgDat->setGeometry(10,y,w,h);
	imgDat->update();

	y+=h+5;

	w2=filewidget->sizeHint().width()+5;
	h2=filewidget->sizeHint().height();
	filewidget->setGeometry(10,y,w2,h2);
        y+=5+h2;
	w=MAX(w,w2);
	
	w2=filter->sizeHint().width();
	w3=transmit->sizeHint().width();
	h2=filter->sizeHint().height();
	filter->setGeometry(10,y,w2,h2);
	transmit->setGeometry(10+w2+5,y,w3,h2);

	w=MAX(w,15+w2+w3);
	y+=h2+5;

	w2=once->sizeHint().width();
	h2=once->sizeHint().height();
	once->setGeometry(10,y,w2,h2);
	y+=h2+5;

	tab=MAX(maplabel->sizeHint().width(),interpolatelabel->sizeHint().width());

	w2=maplabel->sizeHint().width();
	w3=mapping->sizeHint().width();
	h2=mapping->sizeHint().height();	
	maplabel->setGeometry(10,y,w2,h2);
	mapping->setGeometry(15+tab,y,w3,h2);
	if ((15+w2+w3)>w) w=15+w2+w3;
	y+=h2+5;
	
	w2=interpolatelabel->sizeHint().width();
	w3=interpolate->sizeHint().width();
	h2=interpolate->sizeHint().height();		
	interpolatelabel->setGeometry(10,y,w2,h2);
	interpolate->setGeometry(15+tab,y,w3,h2);	
	if ((15+w2+w3)>w) w=15+w2+w3;
	y+=h2+5;

	qs.setWidth(w);
	qs.setHeight(y);	
	if (qp) QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

ImageMapDialog::ImageMapDialog(QWidget *parent,imageMap *i) :
	QDialog(parent,"ImageMapDialog",true)
{
	setCaption(i18n("Imagemap") );

	ok=new QPushButton(i18n("OK"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new ImageMapWidget(this,i);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );
	
	paintEvent(NULL);
}

ImageMapDialog::~ImageMapDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}


void ImageMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void ImageMapDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void ImageMapDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);

	QDialog::paintEvent(qp);
}

