/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifierdialog.cpp
*/
#include "patternmodifierdialog.h"
#include "patternmodifierdialog.moc"

#include "../widgets/sliderwidget.h"

#include <kapp.h>
#include <qtooltip.h>

PatternModifierWidget::PatternModifierWidget(QWidget *parent,patternmodifier *pm, int mo) :
	QWidget(parent,"PatternModifierWidget")
{
	int	w = 0,h = 0;

	pmod=pm;
	mode=mo;	//	0 : show all Patterns
			//      1 : show Pattern for slopemaps

#ifdef DEBUG			
	printf("#### MOde:%d\n",mode);
#endif

	tab=new TabWidget(this,i18n("Pattern:") ,1,NULL);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(tab,i18n("The Pattern of the Map") );
#endif
	connect(tab,SIGNAL(itemChanged()),this,SIGNAL(valueChanged()) );

	page0=new QWidget(tab);
	noOpt=new QLabel(i18n("No Options avaiable") ,page0);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(page0,i18n("No Options avaiable") );
#endif

	w=MAX(noOpt->sizeHint().width(),w);	
	h=MAX(noOpt->sizeHint().height(),h);
	
	agatep=new QWidget(tab);
	agateturb=new SpinBox(agatep,i18n("Agate Turbulence:") ,pmod->getAgateTurbulence() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(agateturb,i18n("Turbulence of this pattern") );
#endif
	connect(agateturb,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(agateturb->sizeHint().width(),w);	
	h=MAX(agateturb->sizeHint().height(),h);


	densityp=new QWidget(tab);
	density=new GetFileWidget(densityp,i18n("Densitymap:") ,pmod->getDensityMap(),0);
	connect(density,SIGNAL(changed()),this,SIGNAL(valueChanged()) );
	dinter=new QCheckBox(i18n("Interpolate") ,densityp);
	dinter->setChecked(pmod->getDensityInterpolation() );
	connect(dinter,SIGNAL(clicked()),this,SIGNAL(valueChanged()) );


	w=MAX(density->sizeHint().width()+10,w);	
	h=MAX(density->sizeHint().height(),h);

	gradientp=new QWidget(tab);
	gradvek=new VectorWidget(gradientp,i18n("Gradient") );
	gradvek->setVector(pmod->getGradient() );
	connect(gradvek,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	w=MAX(gradvek->sizeHint().width(),w);	
	h=MAX(gradvek->sizeHint().height(),h);

	mandelp=new QWidget(tab);
	mandelit=new SpinBox(mandelp,i18n("Iterations:"),pmod->getIterations() );
	mandelit->DownTopValue(0,50);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(mandelit,i18n("Iterations for calculating the Mandbrot-fractal") );
#endif
	connect(mandelit,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(mandelit->sizeHint().width(),w);	
	h=MAX(mandelit->sizeHint().height(),h);

	quiltedp=new QWidget(tab);
	con0=new SpinBox(quiltedp,i18n("Control 0") ,pmod->getControl0() );
	con1=new SpinBox(quiltedp,i18n("Control 1") ,pmod->getControl1() );
	connect(con0,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(con1,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(con0->sizeHint().width(),w);	
	h=MAX(con0->sizeHint().height()*2+10,h);

	radialp=new QWidget(tab);
	radialfreq=new SpinBox(radialp,i18n("Frequency:") ,pmod->getRadialFrequency() );
	connect(radialfreq,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(radialfreq->sizeHint().width(),w);	
	h=MAX(radialfreq->sizeHint().height(),h);

	spiral1p=new QWidget(tab);
	arms1=new SpinBox(spiral1p,i18n("Arms:") ,pmod->getSpiral1Arms() );
	connect(arms1,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(arms1->sizeHint().width(),w);	
	h=MAX(arms1->sizeHint().height(),h);

	spiral2p=new QWidget(tab);
	arms2=new SpinBox(spiral2p,i18n("Arms:") ,pmod->getSpiral2Arms() );
	connect(arms2,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	w=MAX(arms2->sizeHint().width(),w);	
	h=MAX(arms2->sizeHint().height(),h);

	tab->setSize(w+5,h+5);

	connect(tab,SIGNAL(itemChanged()),this,SLOT(changed()) );

	if ((mode!=1)) tab->addWidget(page0,0,(char*)i18n("Wrinkles"));
	else tab->addWidget(page0,0,(char*)i18n("-----"));
	tab->addWidget(agatep,1,(char*)i18n("Agate") );

	if ((mode!=1)) tab->addWidget(page0,2,(char*)i18n("Average") );
	else tab->addWidget(page0,2,(char*)i18n("-----"));

	tab->addWidget(page0,3,(char*)i18n("Boxed") );
	tab->addWidget(page0,4,(char*)i18n("Bozo") );
	if ((mode!=1)) tab->addWidget(page0,5,(char*)i18n("Bumps") );
	else tab->addWidget(page0,5,(char*)i18n("-----"));
	tab->addWidget(page0,6,(char*)i18n("Crackle") );
	tab->addWidget(page0,7,(char*)i18n("Cylindrical") );
	tab->addWidget(densityp,8,(char*)i18n("Density") );
	if ((mode!=1)) tab->addWidget(page0,9,(char*)i18n("Dents") );
	else tab->addWidget(page0,9,(char*)i18n("-----"));
	tab->addWidget(gradientp,10,(char*)i18n("Gradient") );
	tab->addWidget(page0,11,(char*)i18n("Granite") );
	tab->addWidget(page0,12,(char*)i18n("Leopard") );
	tab->addWidget(mandelp,13,(char*)i18n("Mandel") );
	tab->addWidget(page0,14,(char*)i18n("Marble") );
	tab->addWidget(page0,15,(char*)i18n("Onion") );	
	tab->addWidget(page0,16,(char*)i18n("Planar") );
	tab->addWidget(quiltedp,17,(char*)i18n("Quilted") );
	tab->addWidget(radialp,18,(char*)i18n("Radial") );
	if ((mode!=1)) tab->addWidget(page0,19,(char*)i18n("Ripples") );
	else tab->addWidget(page0,19,(char*)i18n("-----"));
	tab->addWidget(page0,20,(char*)i18n("Spherical") );
	tab->addWidget(spiral1p,21,(char*)i18n("Spiral 1") );
	tab->addWidget(spiral2p,22,(char*)i18n("Spiral 2") );
	if ((mode!=1)) tab->addWidget(page0,23,(char*)i18n("Waves") );
	else tab->addWidget(page0,23,(char*)i18n("-----"));
      	tab->addWidget(page0,24,(char*)i18n("Wood") );
	if ((mode!=1)) tab->addWidget(page0,25,(char*)i18n("Brick") );
	else tab->addWidget(page0,25,(char*)i18n("-----"));
	if ((mode!=1)) tab->addWidget(page0,26,(char*)i18n("Checker") );
	else tab->addWidget(page0,26,(char*)i18n("-----"));
	if ((mode!=1)) tab->addWidget(page0,27,(char*)i18n("Hexagon") );
	else tab->addWidget(page0,27,(char*)i18n("-----"));

	tab->select(pmod->getMode());
	//emit sizeChanged();

	paintEvent(NULL);
}

PatternModifierWidget::~PatternModifierWidget()
{
	if (noOpt) delete noOpt;
	if (agateturb) delete agateturb;
	if (density) delete density;
	if (dinter) delete dinter;
	if (gradvek) delete gradvek;	
	if (mandelit) delete mandelit;
	if (con0) delete con0;
	if (con1) delete con1;
	if (radialfreq) delete radialfreq;
	if (arms1) delete arms1;
	if (arms2) delete arms2;
	if (page0) delete page0;
	if (densityp) delete densityp;
	if (gradientp) delete gradientp;
	if (mandelp) delete mandelp;
	if (quiltedp) delete quiltedp;
	if (radialp) delete radialp;
	if (spiral1p) delete spiral1p;
	if (spiral2p) delete spiral2p;	
	if (agatep) delete agatep;
        if (tab) delete tab;
}


void PatternModifierWidget::getPatternModifier()
{

	pmod->setMode( tab->getSelected() );

	if (agateturb) pmod->setAgateTurbulence(agateturb->getValue() );
	if (con0) pmod->setControl0(con0->getValue() );
	if (con1) pmod->setControl1(con1->getValue() );
	if (radialfreq) pmod->setRadialFrequency(radialfreq->getValue() );
	if (arms1) pmod->setSpiral1Arms(arms1->getValue() );
	if (arms2) pmod->setSpiral2Arms(arms2->getValue() );
	if (mandelit) pmod->setIterations(mandelit->getValue() );
	if (gradvek) pmod->setGradient( gradvek->getVector() );
	if (dinter) pmod->setDensityInterpolation(dinter->isChecked() );
	if (density) pmod->setDensityMap( density->getFilename() );
	
}

void PatternModifierWidget::changed()
{
	if (mode==1) {
		int x;
		if (tab->getSelected()==0) x=1;
		if (tab->getSelected()==2) x=3;
		if (tab->getSelected()==5) x=6;
		if (tab->getSelected()==9) x=10;
		if (tab->getSelected()==23) x=24;
		if (tab->getSelected()>25) x=24;
		tab->select(x);
	}
	paintEvent(NULL);
}

QSize PatternModifierWidget::sizeHint() const
{
	return qs;
}

void PatternModifierWidget::paintEvent(QPaintEvent* qp)
{
int w=tab->sizeHint().width();
int h=tab->sizeHint().height();
int h2=0,w2=0;

	tab->setGeometry(0,0,w,h);

	switch(tab->getSelected()) {
		case 1:
			h2=agateturb->sizeHint().height();
			w2=agateturb->sizeHint().width();
			agateturb->setGeometry(w/2-w2/2,h/2-2*h2,w2,h2);
		break;
		case 8:
			h2=density->sizeHint().height();
			w2=density->sizeHint().width();
			density->setGeometry(10,5,w2,h2);
			dinter->setGeometry(10,10+h2,w2,h2);
			h2+=h2;
		break;
		case 10:
			h2=gradvek->sizeHint().height();
			w2=gradvek->sizeHint().width();
			gradvek->setGeometry(w/2-w2,3,w2,h2);
		break;
		case 13:
			h2=mandelit->sizeHint().height();
			w2=mandelit->sizeHint().width();
			mandelit->setGeometry(w/2-w2/2,h/2-h2,w2,h2);
		break;
		case 17:
			h2=con0->sizeHint().height();
			w2=con1->sizeHint().width();
			con0->setGeometry(w/2,10,w2,h2);
			con1->setGeometry(w/2,15+h2,w2,h2);
			h2+=h2;
		break;
		case 18:
			h2=radialfreq->sizeHint().height();
			w2=radialfreq->sizeHint().width();
			radialfreq->setGeometry(w/2-w2/2,h/2-h2*2,w2,h2);
		break;
		case 21:
			h2=arms1->sizeHint().height();
			w2=arms1->sizeHint().width();
			arms1->setGeometry(w/2-w2/2,h/2-h2*2,w2,h2);
		break;
		case 22:
			h2=arms2->sizeHint().height();
			w2=arms2->sizeHint().width();
			arms2->setGeometry(w/2-w2/2,h/2-h2*2,w2,h2);
		break;
		default:
			h2=noOpt->sizeHint().height();
			w2=noOpt->sizeHint().width();
			noOpt->setGeometry(w/2-w2/2,h/2-h2*2,w2,h2);
		break;
        }
	qs.setWidth(w+5);
	qs.setHeight(h);
	if (qp) QWidget::paintEvent(qp);
}


//----------------------------------------------------------

PatternModifierDialog::PatternModifierDialog(QWidget *parent,patternmodifier *n) :
	QDialog(parent,"PatternModifierDialog",true)
{

#ifdef DEBUG
	printf("entering PatternmodifierDialog KOnstruktor\n");
#endif

        setCaption(i18n("Patterns"));
	
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	nw=new PatternModifierWidget(this,n);

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );
	connect (nw,SIGNAL(sizeChanged()),this,SLOT(setSize()) );

	setSize();
#ifdef DEBUG
	printf("exiting PatternmodifierDialog KOnstruktor\n");
#endif
}


void PatternModifierDialog::okayPressed()
{  	
	nw->getPatternModifier();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void PatternModifierDialog::cancelPressed()
{
	QDialog::done(0);
}

PatternModifierDialog::~PatternModifierDialog()
{
}

void PatternModifierDialog::setSize()
{
	int w=nw->sizeHint().width();
	int h=nw->sizeHint().height();
	int h1=ok->sizeHint().height();

	resize(w,h+h1+5);
	setMinimumSize(w,h+h1+5);
	setMaximumSize(w,h+h1+5);
}

void PatternModifierDialog::paintEvent(QPaintEvent* qp)
{
	int w=nw->sizeHint().width();
	int h=nw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	nw->setGeometry(0,0,w,h);

	QDialog::paintEvent(qp);
}

