/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** PreviewView.cpp
*/
#include "previewview.h"
#include "previewview.moc"

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kapp.h>
#include "previewwidget.h"
#include <qtooltip.h>

PreviewView::PreviewView(QWidget *p,const char *name) :
	QWidget(p,name)
{
	preview = new PreviewWidget(this,"Preview");
	actual = 0;
	overrideAutoUpdate = false;

//	zoomIn=new QPushButton("+",this);
//	zoomOut=new QPushButton("-",this);	
//	zoom=new QPushButton("1:1",this);	

	hollow = new QCheckBox(this);
	hollow->setText(i18n("Hollow on"));
#if (USE_QTOOLTIP == 1)
	QToolTip::add(hollow,i18n("Render preview with hollow-flag") );
#endif
	hollow->setChecked(true);

	quick = new QCheckBox(this);
	quick->setText(i18n("Quick Render"));
#if (USE_QTOOLTIP == 1)
	QToolTip::add(quick,i18n("Render the preview in low quality") );	
#endif

	updateBt = new QPushButton(this);
	updateBt->setText(i18n("update"));
#if (USE_QTOOLTIP == 1)
	//QToolTip::add(updateBt,i18n("Render the Preview") );	
#endif
	connect(updateBt,SIGNAL(clicked()),this,SLOT(updateClicked()) );	
	
	autoUpdate = new QCheckBox(this);
	autoUpdate->setText(i18n("Auto Update"));
	
#if (USE_QTOOLTIP == 1)
	QToolTip::add(autoUpdate,i18n("Autorender the Preview") );	
#endif
	autoUpdate->setChecked(true);

	
//	connect(zoomIn,SIGNAL(clicked()),preview,SLOT(zoomIn()) );
//	connect(zoomOut,SIGNAL(clicked()),preview,SLOT(zoomOut()) );
//	connect(zoom,SIGNAL(clicked()),preview,SLOT(originalSize()) );
	connect(hollow,SIGNAL(toggled(bool)),preview,SLOT(setHollow(bool)) );
	connect(quick,SIGNAL(toggled(bool)),preview,SLOT(setQuick(bool)) );
}

PreviewView::~PreviewView()
{
}

void PreviewView::paintEvent(QPaintEvent *qp)
{
int 	z,y=10,w,h;	

	preview->stop();
/*
	w=zoomIn->sizeHint().width();	
	h=zoomIn->sizeHint().height();

	zoomIn->setGeometry(10,10,w,h);
	zoomOut->setGeometry(10+w+5,10,w,h);
	y+=h+5;

	w=zoom->sizeHint().width();	
	zoom->setGeometry(10,y,w,h);

	y+=h+5;
  */

	z=MIN(width()-20,height()-y-10);
	z=MIN(width(),height()/2);

	preview->setGeometry(width()/2-z/2,y,z,z);

	y+=z+5;
	
	w=updateBt->sizeHint().width();
	h=updateBt->sizeHint().height();
	updateBt->setGeometry(width()/2-w/2,y,w,h);

	y+=h+5;

	w=autoUpdate->sizeHint().width();
	h=autoUpdate->sizeHint().height();
	autoUpdate->setGeometry(width()/2-w/2,y,w,h);

	y+=h+10;

	w=quick->sizeHint().width();
	h=quick->sizeHint().height();
	quick->setGeometry(10,y,w,h);

	y+=h+5;

	w=hollow->sizeHint().width();
	h=hollow->sizeHint().height();
	hollow->setGeometry(10,y,w,h);

	y+=h+5;

	updateContent();


	if (qp) QWidget::paintEvent(qp);
}

void PreviewView::updateClicked()
{
	overrideAutoUpdate=true;
	updateContent();
}

void PreviewView::updateContent(textureBase *t)
{
	textureBase	*tb = t;
	
	if(!t)
		return;
	if((overrideAutoUpdate == true) || (autoUpdate->isChecked() == true))
	{
		preview->stop();	
		if(tb->getType() != TEXTURE)
		{
			if((tb->getType() == TEXTUREBOOK) || (tb->getType() == TEXTURELIBRARY))
				return;
			while(tb->getType() != TEXTURE)
			{
				if(tb)
					tb = tb->getParent();
				if((tb->getType() == TEXTUREBOOK) || (tb->getType() == TEXTURELIBRARY))
					return;
			}
			actual=tb;
		}
		else
			actual=tb;
		updateContent();
	}
	overrideAutoUpdate = false;
}

void PreviewView::updateContent()
{
	if((overrideAutoUpdate == true) || (autoUpdate->isChecked() == true))
	{
		preview->stop();
       		if(actual)
       		{
			preview->render((texture*)actual);
		}
	}
	overrideAutoUpdate = false;
}
