/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfaceentrywidget.cpp
*/

#include "surfaceentrywidget.h"
#include "surfaceentrywidget.moc"

#include <kapp.h>

SurfaceEntryWidget::SurfaceEntryWidget(QWidget *parent,surfaceEntry *c) :
	TextureWidgetBase(parent,"SurfaceEntryDialog")
{
	co=c;

	tbasew=new TextureBaseWidget(this,co);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	range=new SpinBox(this,i18n("Range"),co->getRange());
	range->DownTopValue(0,1);
	connect(range,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	layer=new SpinBox(this,i18n("Layer:"),(double)co->getLayer());
	layer->switchToIntMode();
	layer->DownTopValue(-1,500);
	layer->setStep(1);
	layer->setValue((double)co->getLayer() );
	connect(layer,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

void SurfaceEntryWidget::getValue()
{
	co->setLayer( (int)layer->getValue() );
	co->setRange( range->getValue() );
	tbasew->getTextureBase();
}

SurfaceEntryWidget::~SurfaceEntryWidget()
{
	if (tbasew) delete tbasew;
	if (layer) delete layer;
	if (range) delete range;
}

QSize SurfaceEntryWidget::sizeHint() const
{
	return qs;
}

void SurfaceEntryWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();	
int h=tbasew->sizeHint().height();
int y=10,h2=0,w2;

        tbasew->setGeometry(10,y,w,h);
	y+=h+5;

	h2=layer->sizeHint().height();
	w2=layer->sizeHint().width();
	layer->setGeometry(10,y,w2,h2);

	w=MAX(w,w2);
	y+=h2+5;

	h2=range->sizeHint().height();
	w2=range->sizeHint().width();
	range->setGeometry(10,y,w2,h2);

	w=MAX(w,w2);
	y+=h2+5;

	qs.setHeight(y);
	qs.setWidth(w);	
		
	if (qp) QWidget::paintEvent(qp);

}
//------------------------------------------------------------------------

SurfaceEntryDialog::SurfaceEntryDialog(QWidget *parent,surfaceEntry *c) :
	QDialog(parent,"SurfaceEntryDialog",true)
{
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new SurfaceEntryWidget(this,c);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );
	
	setSize();	
}

SurfaceEntryDialog::~SurfaceEntryDialog()
{
}


void SurfaceEntryDialog::cancelPressed()
{
	QDialog::done(0);
}

void SurfaceEntryDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void SurfaceEntryDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);

	QDialog::paintEvent(qp);
}

void SurfaceEntryDialog::setSize()
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();
	int h1=ok->sizeHint().height();

	resize(w,h+h1+5);
	setMinimumSize(w,h+h1+5);
	setMaximumSize(w,h+h1+5);
}
