/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.cpp
*/
#include "textureattributeview.h"
#include "textureattributeview.moc"


#include "icons/addturbulence.xpm"
#include "icons/changeturbulence.xpm"
#include "icons/addtransition.xpm"
#include "icons/changetransition.xpm"
#include "icons/ok.xpm"
#include "icons/X.xpm"
#include "icons/turbulence.xpm"
#include "icons/transform.xpm"


TextureAttributeView::TextureAttributeView(QWidget *p,const char *name) :
	QFrame(p,name)
{
	justOpen = 0;
	selTB = 0;

	       	
	scroll = new QScrollView(this);

	
	paintEvent(0);

}

TextureAttributeView::~TextureAttributeView()
{
}

void TextureAttributeView::applyChanges()
{
	if (justOpen)
	{
		justOpen->getValue();
		emit valueChanged(selTB);
	}
}

void TextureAttributeView::originalValues()
{
	newTextureSelection(selTB);
}

void TextureAttributeView::newTextureSelection(textureBase *tb)
{
	if (justOpen)
	{
		scroll->removeChild(justOpen);
		delete justOpen;
		justOpen=NULL;
	}
        if (!tb) return;
	selTB=tb;
	switch(tb->getType())
	{
		case COLOR: justOpen=new ColorWidget(scroll,(color*)tb);
		break;
		case COLORENTRY: justOpen=new ColorEntryWidget(scroll,(colorEntry*)tb);
		break;
		case COLORLIST: justOpen=new ColorListWidget(scroll,(colorList*)tb);
		break;
		case IMAGEMAP: justOpen=new ImageMapWidget(scroll,(imageMap*)tb);
		break;
		case COLORMAP: justOpen=new ColorMapWidget(scroll,(colorMap*)tb);
		break;
		case PIGMENT: justOpen=new PigmentWidget(scroll,(pigment*)tb);
		break;
		case PIGMENTMAP: justOpen=new PigmentMapWidget(scroll,(pigmentMap*)tb);
		break;
		case PIGMENTLIST: justOpen=new PigmentListWidget(scroll,(pigmentList*)tb);
		break;
		case NORMAL: justOpen=new NormalWidget(scroll,(normal*)tb);
		break;
		case BUMPMAP: justOpen=new BumpMapWidget(scroll,(bumpMap*)tb);
		break;
		case SLOPEMAP: justOpen=new SlopeMapWidget(scroll,(slopeMap*)tb);
		break;
		case SLOPEENTRY: justOpen=new SlopeEntryWidget(scroll,(slopeEntry*)tb);
		break;
		case FINISH: justOpen=new FinishWidget(scroll,(finish*)tb);
		break;
		case DENSITY: justOpen=new DensityWidget(scroll,(Density*)tb);
		break;
		case INTERIOR: justOpen=new InteriorWidget(scroll,(interior*)tb);
		break;
		case TURBULENCEMODIFIER: justOpen=new TurbulenceWidget(scroll,(Turbulence*)tb);
		break;
		case TRANSFORMATIONS: justOpen=new TransformationsWidget(scroll,(Transformations*)tb);
		break;
		case TEXTURE: justOpen=new TextureWidget(scroll,(texture*)tb);
		break;
		case SURFACE: justOpen=new SurfaceWidget(scroll,(surface*)tb);
		break;
		case NORMALLIST: justOpen=new NormalListWidget(scroll,(normalList*)tb);
		break;
		case NORMALMAP: justOpen=new NormalMapWidget(scroll,(normalMap*)tb);
		break;
		case NORMALENTRY: justOpen=new NormalEntryWidget(scroll,(normalEntry*)tb);
		break;
		case SURFACELIST: justOpen=new SurfaceListWidget(scroll,(surfaceList*)tb);
		break;
		case SURFACEMAP: justOpen=new SurfaceMapWidget(scroll,(surfaceMap*)tb);
		break;
		case SURFACEENTRY: justOpen=new SurfaceEntryWidget(scroll,(surfaceEntry*)tb);
		break;
		case PIGMENTENTRY: justOpen=new PigmentEntryWidget(scroll,(pigmentEntry*)tb);
		break;
		case WARP: justOpen=new warpWidget(scroll,(warp*)tb);
		break;
		case BLACKHOLEWARP: justOpen=new blackHoleWarpWidget(scroll,(blackHoleWarp*)tb);
		break;
		case REPEATWARP: justOpen=new repeatWarpWidget(scroll,(repeatWarp*)tb);
		break;


		default:
		break;
	}

	if (justOpen)
	{
		scroll->addChild(justOpen);
		scroll->showChild(justOpen,true);
		connect(justOpen,SIGNAL(valueChanged()),this,SLOT(changed()) );
	}
	paintEvent(0);
}

void 	TextureAttributeView::changed()
{
	justOpen->getValue();
	emit valueChanged(selTB);
}

void 	TextureAttributeView::paintEvent(QPaintEvent *qp)
{
	QScrollBar	*horiz=scroll->horizontalScrollBar();
	QScrollBar	*vert=scroll->verticalScrollBar();
	int		sbh=0,sbw=0;
	

	if (vert) sbw=vert->sizeHint().width();
	if (horiz) sbh=horiz->sizeHint().height();

	if (justOpen)
	{
		int w1=justOpen->sizeHint().width()+5;
		int h1=justOpen->sizeHint().height()+5;
		if (width()-50>w1) sbw=0;
		if (height()>h1) sbh=0;
		scroll->resizeContents(w1,h1);
		justOpen->setGeometry(0,0,w1,h1);

		scroll->setGeometry(10,10,MIN(width()-10,w1+2*sbw),MIN(height(),h1+2*sbh) );
	} else{
		scroll->resizeContents(0,0);
		scroll->setGeometry(50,10,0,0);
	}
//	modifyBt->setGeometry(5,20,30,30);
//	unModifyBt->setGeometry(5,55,30,30);

  	if (qp) QWidget::paintEvent(qp);
}

