/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturelistview.h
*/
#ifndef __TEXTURELISTVIEW_H__
#define __TEXTURELISTVIEW_H__


#include <qtabdialog.h>

#include "../widgets/treelist.h"
//#include "patternmodifierdialog.h"
#include "../../3d/textures/texture.h"
#include "../../3d/textures/warp.h"
#include "../../3d/textures/texturelibrary.h"
#include "../../3d/textures/texturebook.h"
#include "../dialogs/renamedialog.h"
#include "../editor/drag3dds.h"
#include "colorwidget.h"
/*
#include "densitydialog.h"
#include "colorentrywidget.h"
#include "imagemapdialog.h"
#include "bumpmapdialog.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "interiordialog.h"
#include "finishdialog.h"
*/
#include <qstring.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qmenubar.h>
#include "../dialogs/dialogs.h"
#include "qtooltip.h"
/*
#include "pigmentdialog.h"
#include "normaldialog.h"
#include "finishdialog.h"
#include "interiordialog.h"
#include "texturedialog.h"
*/
#include <klocale.h>
#include <ktoolbar.h>
#include <qmenubar.h>
#include "../editor/mainwin.h"
#include <chunk.h>
#include <objects.h>

#include "texturewindow.h"


class TextureListListView;
class TextureListItem;

class	 TextureListView: public  QWidget
{
Q_OBJECT
protected:

	int	nameColumn, infoColumn, activeColumn;	
	
	bool isCh;

	QMenuBar	*MenuBar;
	KToolBar	*ToolBar;

	QPopupMenu	*TextureNewPopup;
	//TextureListItem	*lastFolder,*lastItem;

	TextureLibrary	*tlib;

	TextureListListView	*treelist;
	QPushButton	*newbook,*inslib,*savelib,*newlib;
	InfoDialog	*infod;


	void insertLib();

	void saveLib();
public:

	TextureListView(QWidget *p, const char *name,TextureLibrary *);
	~TextureListView();
	void 	paintEvent(QPaintEvent *qp);

	void init();

public slots:

	void insertItemSelected(int x);

	void updateSelected();

      	void loadLib(char *);
	void MenuItemSel(int );

	void doubleClicked(QListViewItem *);
	void selChanged(QListViewItem *);
	void popupClicked(QListViewItem *,int,int);	
	void rightButtonClicked(QListViewItem *,const QPoint &,int);

	void StandardPopupSel(int);

	void addSubItems(TextureListItem *,textureBase *);
	void addItem(TextureListItem *,textureBase *);
	void addItem(TreeList *,textureBase *);

	void updateItem(TextureListItem *);
	void updateAll();

	void exportTLib();

	void setWorld(world *);


signals:
	void colorItemSelected( color *);
	void changedTexture(texture *);
	void message(QString);
	void newTextureSelection(textureBase *);
};

class	TextureListItem : public TreeListItem
{
protected:
	textureBase	*data;
	
public:
	TextureListItem(QListView *p,int h);
	TextureListItem(QListView *p,const char* t1,int h);
	TextureListItem(QListViewItem *p,int h);
	TextureListItem(QListViewItem *p,const char* t1,int h);
	
	textureBase	*getData();
	void		setData(textureBase*);
	
};

class 	TextureListListView: public TreeList
{
Q_OBJECT
public:
	TextureListListView(QWidget *p, char *name);
	~TextureListListView();	
	void 	setLib(TextureLibrary *);
	
protected:
        TextureListView *tview;
	QPopupMenu	*DnDPopup;
	TextureLibrary *tlib;



	virtual void	dragEnterEvent(QDragEnterEvent *de);
	virtual void	dragLeaveEvent(QDragLeaveEvent *de);
	virtual void	dragMoveEvent(QDragMoveEvent *de);
	virtual void	dropEvent(QDropEvent *de);

	virtual void	startDragCopy(QListViewItem *item,QWidget *dragsource);
	virtual void	startDragMove(QListViewItem *item,QWidget *dragsource);

};

#endif
