/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.cpp
*/
#include "textureview.h"
#include "textureview.moc"

#include "texturelistview.h"


TextureView::TextureView(QWidget *p,const char *name) :
	KNewPanner(p,name,KNewPanner::Vertical,KNewPanner::Percent,35)
{
	tlib=new TextureLibrary();
	
	panner=new KNewPanner(this,"Panner",KNewPanner::Vertical,KNewPanner::Percent,70);

	tlv=new TextureListView(this,NULL,tlib);
	tav=new TextureAttributeView(panner,NULL);

	prv=new PreviewView(panner,"PreviewView");

        connect(tlv,SIGNAL(newTextureSelection(textureBase*)),tav,SLOT(newTextureSelection(textureBase*)) );
        connect(tav,SIGNAL(valueChanged(textureBase *)),tlv,SLOT(updateSelected()) );

        connect(tlv,SIGNAL(newTextureSelection(textureBase*)),prv,SLOT(updateContent(textureBase*)) );
        connect(tav,SIGNAL(valueChanged(textureBase *)),prv,SLOT(updateContent(textureBase *)) );

	connect(tlv,SIGNAL(changedTexture(texture*)),this,SIGNAL(changedTexture(texture *)) );
	//connect(tlv,SIGNAL(changedTexture(texture*)),tav,SLOT(newTextureSelection(texture *)) );

//	panner->activate(tav,new QWidget(panner,"PreviewView"));
	panner->activate(tav,prv);
	activate(tlv,panner);

}

TextureView::~TextureView()
{
	if (tlib) delete tlib;
	if (tlv) delete tlv;
	if (tav) delete tav;
}

TextureListView *TextureView::getTextureListView()
{
	return tlv;
}


TextureLibrary *TextureView::getTextureLibrary()
{
	return tlib;
}


void TextureView::setWorld(world *w)
{
	if (w) tlv->setWorld(w);
	emit changedLibrary(w->getTextureLibrary());
}

void TextureView::MenuItemSel(int x)
{
}

void	TextureView::resizeEvent(QResizeEvent* qr)
{
	int w,x;
	int h=height();

	w=width();
	x=seperatorPos();

	setGeometry(0,0,w,h);

	tlv->setGeometry(0,0,w*x/100,h);
	panner->setGeometry(5+w*x/100,0,w*(100-x)/100-5,h);
	

	if (qr) KNewPanner::resizeEvent(qr);	
}

