/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformationswidget.cpp
*/
#include "transformationswidget.h"
#include "transformationswidget.moc"

#include <kapp.h>

TransformationsWidget::TransformationsWidget(QWidget *p,Transformations *t) :
	TextureWidgetBase(p,"Transformationswidget")
{
        tr=t;

	tab=new TabWidget(this,(const char*)"Transformations",0);

	scale=new VectorWidget(this,i18n("Scale") );
	rotate=new VectorWidget(this,i18n("Rotate") );
	translate=new VectorWidget(this,i18n("Translate") );	

	tab->addWidget(scale,0,(char*)i18n("Scale"));
	tab->addWidget(rotate,1,(char*)i18n("Rotate"));
	tab->addWidget(translate,2,(char*)i18n("Translate"));
	tab->select(0);

        scale->setVector( tr->getScaling() );
        rotate->setVector( tr->getRotation() );
        translate->setVector( tr->getTranslation() );

	connect(scale,SIGNAL(changed()),this,SIGNAL(valueChanged()) );
	connect(rotate,SIGNAL(changed()),this,SIGNAL(valueChanged()) );
	connect(translate,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

TransformationsWidget::~TransformationsWidget()
{
	if (scale) delete scale;
	if (rotate) delete rotate;
	if (translate) delete translate;
	if (tab) delete tab;
}

void TransformationsWidget::getValue()
{
	tr->setTranslation( translate->getVector() );
	tr->setRotation(rotate->getVector()  );	
	tr->setScaling(scale->getVector()   );
}

QSize TransformationsWidget::sizeHint() const
{
	return qs;
}

void TransformationsWidget::paintEvent(QPaintEvent* qp)
{
	int w=scale->sizeHint().width();
	int h=scale->sizeHint().height();

	scale->setGeometry(10,10,w,h);
	rotate->setGeometry(10,10,w,h);
	translate->setGeometry(10,10,w,h);

	tab->setSize(w+10,h+15);

	h=tab->sizeHint().height();
	w=tab->sizeHint().width();

	tab->setGeometry(10,20,w,h);

	qs.setWidth(w+10);
	qs.setHeight(h+20);
	if (qp) QWidget::paintEvent(qp);
}


